/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.mobicents.media.server.component.audio.AudioOutput;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.rtp.RTPDataChannel;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.spi.FormatNotSupportedException;
import org.mobicents.media.server.spi.dsp.Processor;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.spi.memory.Frame;

public class RTPOutput
extends AbstractSink {
    private AudioFormat format = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    private RTPDataChannel channel;
    private Formats formats;
    private Processor dsp;
    private static final Logger logger = Logger.getLogger(RTPOutput.class);
    private AudioOutput output;

    protected RTPOutput(Scheduler scheduler, RTPDataChannel channel) {
        super("Output");
        this.channel = channel;
        this.output = new AudioOutput(scheduler, 1);
        this.output.join((AbstractSink)this);
    }

    public AudioOutput getAudioOutput() {
        return this.output;
    }

    public void activate() {
        this.output.start();
    }

    public void deactivate() {
        this.output.stop();
    }

    public void setDsp(Processor dsp) {
        this.dsp = dsp;
    }

    public Processor getDsp() {
        return this.dsp;
    }

    public void setFormats(Formats formats) throws FormatNotSupportedException {
        this.formats = formats;
    }

    public void onMediaTransfer(Frame frame) throws IOException {
        if (this.dsp != null && this.formats != null && !this.formats.isEmpty()) {
            try {
                frame = this.dsp.process(frame, (Format)this.format, this.formats.get(0));
            }
            catch (Exception e) {
                logger.error((Object)e);
                return;
            }
        }
        this.channel.send(frame);
    }
}

