/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.Serializable;
import java.nio.ByteBuffer;

public class RtpPacket
implements Serializable {
    private ByteBuffer buffer;

    public RtpPacket(int capacity, boolean allocateDirect) {
        this.buffer = allocateDirect ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
    }

    protected ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getVersion() {
        return (this.buffer.get(0) & 0xC0) >> 6;
    }

    public int getContributingSource() {
        return this.buffer.get(0) & 0xF;
    }

    public boolean hasPadding() {
        return (this.buffer.get(0) & 0x20) == 32;
    }

    public boolean hasExtensions() {
        return (this.buffer.get(0) & 0x10) == 16;
    }

    public boolean getMarker() {
        return (this.buffer.get(1) & 0xFF & 0x80) == 128;
    }

    public int getPayloadType() {
        return this.buffer.get(1) & 0xFF & 0x7F;
    }

    public int getSeqNumber() {
        return this.buffer.getShort(2) & 0xFFFF;
    }

    public long getTimestamp() {
        return (long)(this.buffer.get(4) & 0xFF) << 24 | (long)(this.buffer.get(5) & 0xFF) << 16 | (long)(this.buffer.get(6) & 0xFF) << 8 | (long)(this.buffer.get(7) & 0xFF);
    }

    public long getSyncSource() {
        return (long)(this.buffer.get(8) & 0xFF) << 24 | (long)(this.buffer.get(9) & 0xFF) << 16 | (long)(this.buffer.get(10) & 0xFF) << 8 | (long)(this.buffer.get(11) & 0xFF);
    }

    public int getPayloadLength() {
        return this.buffer.limit() - 12;
    }

    public void getPyalod(byte[] buff, int offset) {
        this.buffer.position(12);
        this.buffer.get(buff, offset, this.buffer.limit() - 12);
    }

    public void wrap(boolean mark, int payloadType, int seqNumber, long timestamp, long ssrc, byte[] data, int offset, int len) {
        this.buffer.clear();
        this.buffer.rewind();
        this.buffer.put((byte)-128);
        byte b = (byte)payloadType;
        if (mark) {
            b = (byte)(b | 0x80);
        }
        this.buffer.put(b);
        this.buffer.put((byte)((seqNumber & 0xFF00) >> 8));
        this.buffer.put((byte)(seqNumber & 0xFF));
        this.buffer.put((byte)((timestamp & 0xFFFFFFFFFF000000L) >> 24));
        this.buffer.put((byte)((timestamp & 0xFF0000L) >> 16));
        this.buffer.put((byte)((timestamp & 0xFF00L) >> 8));
        this.buffer.put((byte)(timestamp & 0xFFL));
        this.buffer.put((byte)((ssrc & 0xFFFFFFFFFF000000L) >> 24));
        this.buffer.put((byte)((ssrc & 0xFF0000L) >> 16));
        this.buffer.put((byte)((ssrc & 0xFF00L) >> 8));
        this.buffer.put((byte)(ssrc & 0xFFL));
        this.buffer.put(data, offset, len);
        this.buffer.flip();
        this.buffer.rewind();
    }

    public String toString() {
        return "RTP Packet[marker=" + this.getMarker() + ", seq=" + this.getSeqNumber() + ", timestamp=" + this.getTimestamp() + ", payload_size=" + this.getPayloadLength() + ", payload=" + this.getPayloadType() + "]";
    }
}

