/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.rfc2833;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.mobicents.media.server.component.oob.OOBInput;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.rtp.RtpClock;
import org.mobicents.media.server.impl.rtp.RtpPacket;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class DtmfInput
extends AbstractSource {
    private static final AudioFormat dtmf = FormatFactory.createAudioFormat((String)"telephone-event", (int)8000);
    private long period = 20000000L;
    private int packetSize = 4;
    private ArrayList<Frame> frameBuffer = new ArrayList(5);
    private Frame currFrame;
    private byte currTone = (byte)-1;
    private int latestDuration = 0;
    private int latestSeq = 0;
    private boolean hasEndOfEvent;
    private long endTime = 0L;
    private int endSeq = 0;
    private int eventDuration = 0;
    byte[] data = new byte[4];
    boolean endOfEvent;
    private RtpClock clock;
    private OOBInput input;
    private static final Logger logger = Logger.getLogger(DtmfInput.class);

    public DtmfInput(Scheduler scheduler, RtpClock clock) {
        super("dtmfconverter", scheduler, Scheduler.INPUT_QUEUE.intValue());
        this.clock = clock;
        this.clock.setClockRate(8000);
        this.input = new OOBInput(2);
        this.connect((AbstractSink)this.input);
    }

    public OOBInput getOOBInput() {
        return this.input;
    }

    public void setClock(RtpClock clock) {
        this.clock = clock;
        this.clock.setClockRate(8000);
    }

    public void write(RtpPacket event) {
        byte[] newData;
        int i;
        event.getPyalod(this.data, 0);
        if (this.data.length == 0) {
            return;
        }
        boolean endOfEvent = false;
        if (this.data.length > 1) {
            boolean bl = endOfEvent = (this.data[1] & 0x80) != 0;
        }
        if (endOfEvent) {
            this.hasEndOfEvent = true;
            this.endTime = event.getTimestamp();
            this.endSeq = event.getSeqNumber();
            return;
        }
        this.eventDuration = this.data[2] << 8 | this.data[3] & 0xFF;
        if (this.currTone == this.data[0]) {
            if (this.hasEndOfEvent) {
                if (event.getSeqNumber() <= this.endSeq && event.getSeqNumber() > this.endSeq - 8) {
                    return;
                }
            } else {
                if (event.getSeqNumber() < this.latestSeq + 8 && event.getSeqNumber() > this.latestSeq - 8) {
                    if (event.getSeqNumber() > this.latestSeq) {
                        this.latestSeq = event.getSeqNumber();
                        this.latestDuration = this.eventDuration;
                    }
                    return;
                }
                if (this.eventDuration < this.latestDuration + 1280 && this.eventDuration > this.latestDuration - 1280) {
                    if (this.eventDuration > this.latestDuration) {
                        this.latestSeq = event.getSeqNumber();
                        this.latestDuration = this.eventDuration;
                    }
                    return;
                }
            }
        }
        this.hasEndOfEvent = false;
        this.endTime = 0L;
        this.endSeq = 0;
        this.latestSeq = event.getSeqNumber();
        this.latestDuration = this.eventDuration;
        this.currTone = this.data[0];
        for (i = 0; i < 7; ++i) {
            this.currFrame = Memory.allocate((int)this.packetSize);
            newData = this.currFrame.getData();
            newData[0] = this.data[0];
            newData[1] = (byte)(0x3F & this.data[1]);
            this.eventDuration = (short)(160 * i);
            newData[2] = (byte)(this.eventDuration >> 8 & 0xFF);
            newData[3] = (byte)(this.eventDuration & 0xFF);
            this.currFrame.setSequenceNumber((long)(event.getSeqNumber() + i));
            this.currFrame.setOffset(0);
            this.currFrame.setLength(this.packetSize);
            this.currFrame.setFormat((Format)dtmf);
            this.currFrame.setDuration(this.period);
            this.currFrame.setTimestamp(this.clock.convertToAbsoluteTime(event.getTimestamp() + (long)(20 * i)));
            this.frameBuffer.add(this.currFrame);
        }
        for (i = 7; i < 10; ++i) {
            this.currFrame = Memory.allocate((int)this.packetSize);
            newData = this.currFrame.getData();
            newData[0] = this.data[0];
            newData[1] = (byte)(0x80 | this.data[1]);
            this.eventDuration = (short)(160 * i);
            newData[2] = (byte)(this.eventDuration >> 8 & 0xFF);
            newData[3] = (byte)(this.eventDuration & 0xFF);
            this.currFrame.setSequenceNumber((long)(event.getSeqNumber() + i));
            this.currFrame.setOffset(0);
            this.currFrame.setLength(this.packetSize);
            this.currFrame.setFormat((Format)dtmf);
            this.currFrame.setDuration(this.period);
            this.currFrame.setTimestamp(this.clock.convertToAbsoluteTime(event.getTimestamp() + (long)(20 * i)));
            this.frameBuffer.add(this.currFrame);
        }
        this.wakeup();
    }

    public Frame evolve(long timestamp) {
        if (this.frameBuffer.size() == 0) {
            return null;
        }
        return this.frameBuffer.remove(0);
    }

    public void reset() {
        this.hasEndOfEvent = false;
        this.endTime = 0L;
        this.endSeq = 0;
        this.latestSeq = 0;
        this.latestDuration = 0;
        this.currTone = (byte)-1;
    }
}

