/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.rfc2833;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.mobicents.media.server.component.oob.OOBOutput;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.rtp.RTPDataChannel;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.memory.Frame;

public class DtmfOutput
extends AbstractSink {
    private static final AudioFormat dtmf = FormatFactory.createAudioFormat((String)"telephone-event", (int)8000);
    private RTPDataChannel channel;
    private static final Logger logger = Logger.getLogger(DtmfOutput.class);
    private OOBOutput oobOutput;

    public DtmfOutput(Scheduler scheduler, RTPDataChannel channel) {
        super("Output");
        this.channel = channel;
        this.oobOutput = new OOBOutput(scheduler, 1);
        this.oobOutput.join((AbstractSink)this);
    }

    public OOBOutput getOOBOutput() {
        return this.oobOutput;
    }

    public void activate() {
        this.oobOutput.start();
    }

    public void deactivate() {
        this.oobOutput.stop();
    }

    public void onMediaTransfer(Frame frame) throws IOException {
        this.channel.sendDtmf(frame);
    }
}

