/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.sdp;

import java.text.ParseException;
import java.util.Iterator;
import org.mobicents.media.server.impl.rtp.sdp.AVProfile;
import org.mobicents.media.server.impl.rtp.sdp.ConnectionField;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormat;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormats;
import org.mobicents.media.server.impl.rtp.sdp.SessionDescription;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.EncodingName;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.VideoFormat;
import org.mobicents.media.server.utils.Text;

public class MediaDescriptorField {
    private Text mediaType;
    private int port;
    private Text profile;
    private ConnectionField connection;
    private RTPFormats formats = new RTPFormats(15);

    protected void setDescriptor(Text line) throws ParseException {
        line.trim();
        try {
            Iterator it = line.split('=').iterator();
            Text t = (Text)it.next();
            t = (Text)it.next();
            it = t.split(' ').iterator();
            this.mediaType = (Text)it.next();
            this.mediaType.trim();
            t = (Text)it.next();
            t.trim();
            this.port = t.toInteger();
            this.profile = (Text)it.next();
            this.profile.trim();
            while (it.hasNext()) {
                t = (Text)it.next();
                t.trim();
                RTPFormat fmt = AVProfile.getFormat(t.toInteger(), this.mediaType);
                if (fmt == null || this.formats.contains(fmt.getFormat())) continue;
                this.formats.add(fmt.clone());
            }
        }
        catch (Exception e) {
            throw new ParseException("Could not parse media descriptor", 0);
        }
    }

    protected void addAttribute(Text attribute) {
        Iterator it = attribute.split(':').iterator();
        Text token = (Text)it.next();
        if (token.equals((Object)SessionDescription.RTPMAP)) {
            token = (Text)it.next();
            token.trim();
            it = token.split(' ').iterator();
            token = (Text)it.next();
            token.trim();
            int payload = token.toInteger();
            token = (Text)it.next();
            token.trim();
            this.createFormat(payload, token);
            return;
        }
        if (token.equals((Object)SessionDescription.FMTP)) {
            token = (Text)it.next();
            token.trim();
            it = token.split(' ').iterator();
            token = (Text)it.next();
            token.trim();
            int payload = token.toInteger();
            token = (Text)it.next();
            token.trim();
            RTPFormat fmt = this.getFormat(payload);
            if (fmt != null) {
                fmt.getFormat().setOptions(token);
            }
            return;
        }
    }

    public ConnectionField getConnection() {
        return this.connection;
    }

    protected void setConnection(Text line) throws ParseException {
        this.connection = new ConnectionField();
        this.connection.strain(line);
    }

    public Text getMediaType() {
        return this.mediaType;
    }

    public int getPort() {
        return this.port;
    }

    public Text getProfile() {
        return this.profile;
    }

    public RTPFormats getFormats() {
        return this.formats;
    }

    private RTPFormat getFormat(int payload) {
        return this.formats.find(payload);
    }

    private String intersection(MediaDescriptorField md) {
        return null;
    }

    private RTPFormat createFormat(int payload, Text description) {
        if (this.mediaType.equals((Object)SessionDescription.AUDIO)) {
            return this.createAudioFormat(payload, description);
        }
        if (this.mediaType.equals((Object)SessionDescription.VIDEO)) {
            return this.createVideoFormat(payload, description);
        }
        return null;
    }

    private RTPFormat createAudioFormat(int payload, Text description) {
        RTPFormat rtpFormat;
        Iterator it = description.split('/').iterator();
        Text token = (Text)it.next();
        token.trim();
        EncodingName name = new EncodingName(token);
        token = (Text)it.next();
        token.trim();
        int clockRate = token.toInteger();
        int channels = 1;
        if (it.hasNext()) {
            token = (Text)it.next();
            token.trim();
            channels = token.toInteger();
        }
        if ((rtpFormat = this.getFormat(payload)) == null) {
            this.formats.add(new RTPFormat(payload, (Format)FormatFactory.createAudioFormat((EncodingName)name, (int)clockRate, (int)-1, (int)channels)));
        } else {
            ((AudioFormat)rtpFormat.getFormat()).setName(name);
            ((AudioFormat)rtpFormat.getFormat()).setSampleRate(clockRate);
            ((AudioFormat)rtpFormat.getFormat()).setChannels(channels);
        }
        return rtpFormat;
    }

    private RTPFormat createVideoFormat(int payload, Text description) {
        Iterator it = description.split('/').iterator();
        Text token = (Text)it.next();
        token.trim();
        EncodingName name = new EncodingName(token);
        token = (Text)it.next();
        token.trim();
        int clockRate = token.toInteger();
        RTPFormat rtpFormat = this.getFormat(payload);
        if (rtpFormat == null) {
            this.formats.add(new RTPFormat(payload, (Format)FormatFactory.createVideoFormat((EncodingName)name, (int)clockRate)));
        } else {
            ((VideoFormat)rtpFormat.getFormat()).setName(name);
            ((VideoFormat)rtpFormat.getFormat()).setFrameRate(clockRate);
        }
        return rtpFormat;
    }
}

