/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.sdp;

import java.util.Collection;
import org.mobicents.media.server.impl.rtp.sdp.MediaDescriptorField;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormats;
import org.mobicents.media.server.impl.rtp.sdp.SessionDescription;
import org.mobicents.media.server.utils.Text;

public class SdpComparator {
    protected static final Text AUDIO = new Text("audio");
    protected static final Text VIDEO = new Text("video");
    private RTPFormats audio = new RTPFormats();
    private RTPFormats video = new RTPFormats();

    public void negotiate(SessionDescription sdp, RTPFormats audio, RTPFormats video) {
        this.audio.clean();
        this.video.clean();
        Collection<MediaDescriptorField> mds = sdp.getMedia();
        for (MediaDescriptorField md : mds) {
            if (md.getMediaType().equals((Object)AUDIO)) {
                if (audio == null) continue;
                md.getFormats().intersection(audio, this.audio);
                continue;
            }
            if (video == null) continue;
            md.getFormats().intersection(video, this.video);
        }
    }

    public void compare(SessionDescription sdp1, SessionDescription sdp2) {
        this.audio.clean();
        this.video.clean();
        Collection<MediaDescriptorField> mds1 = sdp1.getMedia();
        Collection<MediaDescriptorField> mds2 = sdp2.getMedia();
        for (MediaDescriptorField md1 : mds1) {
            for (MediaDescriptorField md2 : mds2) {
                if (!md1.getMediaType().equals((Object)md2.getMediaType())) continue;
                this.compare(md1, md2);
            }
        }
    }

    private void compare(MediaDescriptorField md1, MediaDescriptorField md2) {
        RTPFormats collector = null;
        collector = md1.getMediaType().equals((Object)AUDIO) ? this.audio : this.video;
        md1.getFormats().intersection(md2.getFormats(), collector);
    }

    public RTPFormats getAudio() {
        return this.audio;
    }

    public RTPFormats getVideo() {
        return this.video;
    }
}

