/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.sdp;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.mobicents.media.server.impl.rtp.sdp.ConnectionField;
import org.mobicents.media.server.impl.rtp.sdp.MediaDescriptorField;
import org.mobicents.media.server.impl.rtp.sdp.OriginField;
import org.mobicents.media.server.impl.rtp.sdp.TimeField;
import org.mobicents.media.server.utils.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionDescription {
    protected static final Text AUDIO = new Text("audio");
    protected static final Text VIDEO = new Text("video");
    protected static final Text RTPMAP = new Text("a=rtpmap");
    protected static final Text FMTP = new Text("a=fmtp");
    private Text version;
    private OriginField origin = new OriginField();
    private Text session;
    private ConnectionField connection = new ConnectionField();
    private TimeField time = new TimeField();
    private ArrayList<MediaDescriptorField> mds = new ArrayList(2);
    private MediaDescriptorField audioDescriptor;
    private MediaDescriptorField videoDescriptor;
    private MediaDescriptorField md;

    public void parse(byte[] data) throws ParseException {
        this.md = null;
        this.mds.clear();
        Text text = new Text();
        text.strain(data, 0, data.length);
        while (text.hasMoreLines()) {
            Text line = text.nextLine();
            if (line.length() == 0) continue;
            switch (line.charAt(0)) {
                case 'v': {
                    Iterator it = line.split('=').iterator();
                    it.next();
                    this.version = (Text)it.next();
                    this.version.trim();
                    break;
                }
                case 'o': {
                    this.origin.strain(line);
                    break;
                }
                case 's': {
                    Iterator it = line.split('=').iterator();
                    it.next();
                    this.session = (Text)it.next();
                    this.session.trim();
                    break;
                }
                case 'c': {
                    if (this.md == null) {
                        this.connection.strain(line);
                        break;
                    }
                    this.md.setConnection(line);
                    break;
                }
                case 't': {
                    this.time.strain(line);
                    break;
                }
                case 'm': {
                    this.md = new MediaDescriptorField();
                    this.mds.add(this.md);
                    this.md.setDescriptor(line);
                    if (this.md.getMediaType().equals((Object)AUDIO)) {
                        this.audioDescriptor = this.md;
                        break;
                    }
                    this.videoDescriptor = this.md;
                    break;
                }
                case 'a': {
                    if (this.md == null) break;
                    this.md.addAttribute(line);
                }
            }
        }
    }

    public void init(Text text) throws ParseException {
        this.md = null;
        this.mds.clear();
        while (text.hasMoreLines()) {
            Text line = text.nextLine();
            if (line.length() == 0) continue;
            switch (line.charAt(0)) {
                case 'v': {
                    Iterator it = line.split('=').iterator();
                    it.next();
                    this.version = (Text)it.next();
                    this.version.trim();
                    break;
                }
                case 'o': {
                    this.origin.strain(line);
                    break;
                }
                case 's': {
                    Iterator it = line.split('=').iterator();
                    it.next();
                    this.session = (Text)it.next();
                    this.session.trim();
                    break;
                }
                case 'c': {
                    if (this.md == null) {
                        this.connection.strain(line);
                        break;
                    }
                    this.md.setConnection(line);
                    break;
                }
                case 't': {
                    this.time.strain(line);
                    break;
                }
                case 'm': {
                    this.md = new MediaDescriptorField();
                    this.mds.add(this.md);
                    this.md.setDescriptor(line);
                    if (this.md.getMediaType().equals((Object)AUDIO)) {
                        this.audioDescriptor = this.md;
                        break;
                    }
                    this.videoDescriptor = this.md;
                    break;
                }
                case 'a': {
                    if (this.md == null) break;
                    this.md.addAttribute(line);
                }
            }
        }
    }

    public Text getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = new Text(version);
    }

    public OriginField getOrigin() {
        return this.origin;
    }

    public void setOrigin(String name, String sessionID, String sessionVersion, String netType, String addressType, String address) {
        this.origin = new OriginField(name, sessionID, sessionVersion, netType, addressType, address);
    }

    public String getSession() {
        return this.session.toString();
    }

    public ConnectionField getConnection() {
        return this.connection;
    }

    public TimeField getTime() {
        return this.time;
    }

    public Collection<MediaDescriptorField> getMedia() {
        return this.mds;
    }

    public MediaDescriptorField getAudioDescriptor() {
        return this.audioDescriptor;
    }

    public MediaDescriptorField getVideoDescriptor() {
        return this.videoDescriptor;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("v=%s\n", this.version.toString()));
        builder.append(this.origin.toString());
        return builder.toString();
    }
}

