/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.io.ss7;

import java.io.IOException;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.mobicents.media.hardware.dahdi.Channel;
import org.mobicents.media.hardware.dahdi.Selector;
import org.mobicents.media.hardware.dahdi.SelectorKeyImpl;
import org.mobicents.media.server.io.ss7.ProtocolHandler;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;

public class SS7Manager {
    private Selector selector;
    private PollTask pollTask;
    private volatile boolean isActive;
    private volatile int count;
    private String name = "unknown";
    private static final Logger logger = Logger.getLogger(SS7Manager.class);
    private final Object LOCK = new Object();
    protected Scheduler scheduler;

    public SS7Manager(Scheduler scheduler) throws IOException {
        this.scheduler = scheduler;
        this.selector = new Selector();
        this.pollTask = new PollTask();
    }

    public int getCount() {
        return this.count;
    }

    public Channel open(int channelID) throws IOException {
        Channel channel = new Channel();
        channel.setChannelID(channelID);
        return channel;
    }

    public SelectorKeyImpl bind(Channel channel, ProtocolHandler protocolHandler) {
        channel.open();
        SelectorKeyImpl selectorKey = (SelectorKeyImpl)this.selector.register(channel);
        selectorKey.attach((Object)protocolHandler);
        return selectorKey;
    }

    public void unbind(Channel channel) {
        channel.close();
        this.selector.unregister(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isActive) {
                return;
            }
            this.isActive = true;
            this.pollTask.startNow();
            logger.info((Object)String.format("Initialized SS7 interface[%s]", this.name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.isActive) {
                return;
            }
            this.isActive = false;
            this.pollTask.cancel();
            logger.info((Object)"Stopped");
        }
    }

    private class PollTask
    extends Task {
        public int getQueueNumber() {
            Scheduler cfr_ignored_0 = SS7Manager.this.scheduler;
            return Scheduler.RECEIVER_QUEUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (!SS7Manager.this.isActive) {
                return 0L;
            }
            try {
                FastList it = SS7Manager.this.selector.selectNow(1, 1);
                FastList.Node n = it.head();
                FastList.Node end = it.tail();
                while ((n = n.getNext()) != end) {
                    SelectorKeyImpl key = (SelectorKeyImpl)n.getValue();
                    ((ProtocolHandler)key.attachment()).receive((Channel)key.getStream());
                }
            }
            catch (IOException e) {
                long l = 0L;
                return l;
            }
            finally {
                Scheduler cfr_ignored_0 = SS7Manager.this.scheduler;
                SS7Manager.this.scheduler.submit((Task)this, Scheduler.RECEIVER_QUEUE);
            }
            return 0L;
        }

        public void startNow() {
            Scheduler cfr_ignored_0 = SS7Manager.this.scheduler;
            SS7Manager.this.scheduler.submit((Task)this, Scheduler.RECEIVER_QUEUE);
        }
    }
}

