/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.scheduler;

import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.scheduler.TaskChainListener;
import org.mobicents.media.server.scheduler.TaskListener;

public class TaskChain
implements TaskListener {
    private Task[] task;
    private int wi;
    private int i;
    private TaskChainListener listener;
    private int queueIndex;
    private final Object LOCK = new Object();
    private Scheduler scheduler;

    public TaskChain(int length, Scheduler scheduler) {
        this.scheduler = scheduler;
        this.task = new Task[length];
    }

    public void setListener(TaskChainListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Task task) {
        Object object = this.LOCK;
        synchronized (object) {
            task.setListener(this);
            this.task[this.wi] = task;
            ++this.wi;
        }
    }

    protected void start(int queueIndex) {
        this.i = 0;
        this.queueIndex = queueIndex;
        this.scheduler.submit(this.task[0], queueIndex);
    }

    private void continueExecution() {
        ++this.i;
        if (this.i < this.task.length && this.task[this.i] != null) {
            this.scheduler.submit(this.task[this.i], this.queueIndex);
        } else if (this.listener != null) {
            this.listener.onTermination();
        }
    }

    public void handlerError(Exception e) {
        if (this.listener != null) {
            this.listener.onException(e);
        }
    }

    protected Task[] getTasks() {
        return this.task;
    }

    public void clean() {
        this.wi = 0;
    }

    public void onTerminate() {
        this.continueExecution();
    }
}

