/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.utils;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Text
implements CharSequence {
    protected byte[] chars;
    protected int pos;
    protected int len;
    private int linePointer;
    private int hash = -1;

    public Text() {
    }

    protected Text(Text another) {
        this.chars = another.chars;
        this.pos = another.pos;
        this.len = another.len;
    }

    public Text(String s) {
        this.chars = s.getBytes();
        this.pos = 0;
        this.len = this.chars.length;
    }

    public Text(int i) {
        int remainder;
        this.chars = new byte[10];
        for (remainder = i; remainder >= 10; remainder /= 10) {
            this.chars[this.len++] = (byte)(remainder % 10 + 48);
        }
        this.chars[this.len++] = (byte)(remainder + 48);
        int n = this.len / 2;
        byte b = 0;
        for (int k = 0; k < n; ++k) {
            b = this.chars[this.len - 1 - k];
            this.chars[this.len - 1 - k] = this.chars[k];
            this.chars[k] = b;
        }
        this.pos = 0;
    }

    public Text(byte[] data, int pos, int len) {
        this.chars = data;
        this.pos = pos;
        this.len = len;
    }

    public void strain(byte[] data, int pos, int len) {
        this.chars = data;
        this.pos = pos;
        this.len = len;
        this.linePointer = 0;
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public char charAt(int index) {
        return (char)this.chars[this.pos + index];
    }

    public void copy(Text destination) {
        destination.strain(this.chars, this.pos, this.len);
    }

    public void duplicate(Text destination) {
        System.arraycopy(this.chars, this.pos, destination.chars, destination.pos, this.len);
        destination.len = this.len;
    }

    public int divide(char separator, Text[] parts) {
        int pointer;
        int limit = this.pos + this.len;
        int mark = pointer;
        int count = 0;
        for (pointer = this.pos; pointer < limit; ++pointer) {
            if (this.chars[pointer] != separator) continue;
            parts[count].strain(this.chars, mark, pointer - mark);
            mark = pointer + 1;
            if (++count == parts.length - 1) break;
        }
        parts[count].strain(this.chars, mark, limit - mark);
        return ++count;
    }

    public int divide(char[] separators, Text[] parts) {
        int pointer;
        int limit = this.pos + this.len;
        int mark = pointer;
        int count = 0;
        int k = 0;
        for (pointer = this.pos; pointer < limit; ++pointer) {
            if (this.chars[pointer] != separators[k]) continue;
            parts[count].strain(this.chars, mark, pointer - mark);
            mark = pointer + 1;
            ++k;
            ++count;
        }
        if (limit > mark) {
            parts[count].strain(this.chars, mark, limit - mark);
            ++count;
        }
        return count;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new Text(this.chars, start, end - start);
    }

    public Collection<Text> split(char separator) {
        int pointer;
        int limit = this.pos + this.len;
        int mark = pointer;
        ArrayList<Text> tokens = new ArrayList<Text>();
        for (pointer = this.pos; pointer < limit; ++pointer) {
            if (this.chars[pointer] != separator) continue;
            tokens.add(new Text(this.chars, mark, pointer - mark));
            mark = pointer + 1;
        }
        tokens.add(new Text(this.chars, mark, limit - mark));
        return tokens;
    }

    public void trim() {
        while (this.chars[this.pos] == 32) {
            ++this.pos;
            --this.len;
        }
        while (this.chars[this.pos + this.len - 1] == 32 || this.chars[this.pos + this.len - 1] == 10 || this.chars[this.pos + this.len - 1] == 13) {
            --this.len;
        }
    }

    public Text nextLine() {
        this.linePointer = this.linePointer == 0 ? this.pos : ++this.linePointer;
        int mark = this.linePointer;
        int limit = this.pos + this.len;
        while (this.linePointer < limit && this.chars[this.linePointer] != 10) {
            ++this.linePointer;
        }
        return new Text(this.chars, mark, this.linePointer - mark);
    }

    public boolean hasMoreLines() {
        return this.linePointer < this.pos + this.len;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Text)) {
            return false;
        }
        Text t = (Text)other;
        if (this.len != t.len) {
            return false;
        }
        return this.compareChars(t.chars, t.pos);
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = 469 + Arrays.hashCode(this.chars);
        }
        return this.hash;
    }

    private boolean compareChars(byte[] chars, int pos) {
        for (int i = 0; i < this.len; ++i) {
            if (!this.differentChars((char)this.chars[i + this.pos], (char)chars[i + pos])) continue;
            return false;
        }
        return true;
    }

    private boolean differentChars(char c1, char c2) {
        if ('A' <= c1 && c1 < 'a') {
            c1 = (char)(c1 + 32);
        }
        if ('A' <= c2 && c2 < 'a') {
            c2 = (char)(c2 + 32);
        }
        return c1 != c2;
    }

    @Override
    public String toString() {
        return new String(this.chars, this.pos, this.len).trim();
    }

    public int toInteger() {
        int res = 0;
        for (int i = 0; i < this.len; ++i) {
            res += this.digit(this.pos + i) * this.pow(this.len - i - 1);
        }
        return res;
    }

    private int pow(int a) {
        int res = 1;
        for (int i = 0; i < a; ++i) {
            res *= 10;
        }
        return res;
    }

    private int digit(int pos) {
        return this.chars[pos] - 48;
    }

    public void write(ByteBuffer buffer) {
        buffer.put(this.chars, this.pos, this.len);
    }

    public void copyRemainder(Text other) {
        other.chars = this.chars;
        other.pos = this.linePointer + 1;
        other.len = this.len - this.linePointer - 1;
    }

    public boolean contains(char c) {
        for (int k = this.pos; k < this.len; ++k) {
            if (this.chars[k] != c) continue;
            return true;
        }
        return false;
    }
}

