/*
 * TeleStax, Open Source Cloud Communications  Copyright 2012.
 * and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.mobicents.protocols.ss7.cap.api.service.gprs.primitive;

import java.io.Serializable;

/**
 *
 GPRSCause {PARAMETERS-BOUND : bound} ::= OCTET STRING (SIZE (1 .. 1)) -- Shall only include the cause value. -- 00000000
 * Unspecified -- All other values shall be interpreted as 'Unspecified'. -- -- This parameter indicates the cause for CAP
 * interface related information. -- The GPRSCause mapping to/from GTP cause values specified in the 3GPP TS 29.060 [12] and --
 * to/from 3GPP TS 24.008 [9] GMM cause and SM cause values are outside scope of this document.
 *
 *
 *
 * @author sergey vetyutnev
 *
 */
public interface GPRSCause extends Serializable {

    int getData();

}
