/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.hardware.dialogic;

import java.io.IOException;

public class InterProcessCommunicator {
    private int source;
    private int destination;

    public InterProcessCommunicator(int source, int destination) {
        this.source = source;
        this.destination = destination;
    }

    public byte[] receive() throws IOException {
        byte[] buffer = new byte[1000];
        int len = this.receive(this.source, buffer);
        if (len == -1) {
            throw new IOException("Unable to read message from IPC");
        }
        byte[] message = new byte[len];
        System.arraycopy(buffer, 0, message, 0, len);
        return message;
    }

    public void send(byte[] packet) throws IOException {
        int status = this.send(this.source, this.destination, packet);
        if (status != 0) {
            throw new IOException("Can not send packet");
        }
    }

    private native int receive(int var1, byte[] var2);

    private native int send(int var1, int var2, byte[] var3);

    static {
        System.loadLibrary("ipc");
    }
}

