/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.hardware.dialogic;

import java.io.IOException;
import java.nio.ByteBuffer;

public class InterProcessCommunicator {
    private static final String LIB_NAME = "mobicents-dialogic-linux";
    private int source;
    private int destination;

    public InterProcessCommunicator(int source, int destination) {
        this.source = source;
        this.destination = destination;
    }

    public int read(ByteBuffer b) throws IOException {
        byte[] buffer = new byte[1000];
        int len = this.receive(this.source, buffer);
        if (len == -1) {
            return 0;
        }
        b.put(buffer, 0, len);
        return len;
    }

    public int write(ByteBuffer b) throws IOException {
        int status = -1;
        if (b.hasRemaining()) {
            byte[] packet = new byte[b.limit() - b.position()];
            b.get(packet);
            status = this.send(this.source, this.destination, packet);
        }
        if (status != 0) {
            throw new IOException("Can not send packet");
        }
        return status;
    }

    private native int receive(int var1, byte[] var2);

    private native int send(int var1, int var2, byte[] var3);

    static {
        try {
            System.loadLibrary(LIB_NAME);
            System.out.println("Loaded library mobicents-dialogic-linux");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

