/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.hardware.dialogic;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.mtp.Mtp3PausePrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3ResumePrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3StatusCause;
import org.mobicents.protocols.ss7.mtp.Mtp3StatusPrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3TransferPrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3UserPartBaseImpl;
import org.mobicents.ss7.hardware.dialogic.InterProcessCommunicator;

public class DialogicMtp3UserPart
extends Mtp3UserPartBaseImpl {
    private static final Logger logger = Logger.getLogger(DialogicMtp3UserPart.class);
    private static final int MTP3_PAUSE = 3;
    private static final int MTP3_RESUME = 4;
    private static final int MTP3_STATUS = 5;
    private int sourceModuleId;
    private int destinationModuleId;
    private InterProcessCommunicator ipc = null;
    private MtpStreamHandler streamHandler;
    protected ExecutorService layer3exec;

    public int getSourceModuleId() {
        return this.sourceModuleId;
    }

    public void setSourceModuleId(int sourceModuleId) {
        this.sourceModuleId = sourceModuleId;
    }

    public int getDestinationModuleId() {
        return this.destinationModuleId;
    }

    public void setDestinationModuleId(int destinationModuleId) {
        this.destinationModuleId = destinationModuleId;
    }

    public void start() throws Exception {
        this.ipc = new InterProcessCommunicator(this.sourceModuleId, this.destinationModuleId);
        this.layer3exec = Executors.newFixedThreadPool(1);
        this.streamHandler = new MtpStreamHandler();
        this.layer3exec.execute(this.streamHandler);
        super.start();
    }

    public void stop() throws Exception {
        super.stop();
        this.streamHandler.stop();
        this.layer3exec.shutdown();
    }

    public void sendMessage(Mtp3TransferPrimitive msg) throws IOException {
        if (this.isStarted) {
            byte[] buf = msg.encodeMtp3();
            this.ipc.write(buf);
        }
    }

    private class MtpStreamHandler
    implements Runnable {
        private boolean handlerIsStarted = true;

        private MtpStreamHandler() {
        }

        public void run() {
            while (this.handlerIsStarted) {
                try {
                    byte[] buf = DialogicMtp3UserPart.this.ipc.read();
                    if (!this.handlerIsStarted) {
                        return;
                    }
                    if (buf == null) {
                        logger.warn((Object)"No data received while reading data from the Dialogic card");
                        Thread.sleep(10L);
                        continue;
                    }
                    if (buf.length >= 6) {
                        if (buf[0] == 0) {
                            this.parseMtp3Msg(buf);
                            continue;
                        }
                        Mtp3TransferPrimitive msg = new Mtp3TransferPrimitive();
                        msg.decodeMtp3(buf);
                        DialogicMtp3UserPart.this.sendTransferMessageToLocalUser(msg, msg.getSls());
                        continue;
                    }
                    logger.error((Object)"Error while reading data from the Dialogic card: received the message with length less then 6 bytes");
                }
                catch (Exception e) {
                    logger.error((Object)"Error while reading data from the Dialogic card", (Throwable)e);
                }
            }
        }

        public void stop() {
            this.handlerIsStarted = false;
        }

        private void parseMtp3Msg(byte[] buf) {
            try {
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(buf));
                in.readUnsignedByte();
                int type = in.readUnsignedByte();
                switch (type) {
                    case 3: {
                        Mtp3PausePrimitive msgPause = new Mtp3PausePrimitive(in.readInt());
                        DialogicMtp3UserPart.this.sendPauseMessageToLocalUser(msgPause);
                        break;
                    }
                    case 4: {
                        Mtp3ResumePrimitive msgResume = new Mtp3ResumePrimitive(in.readInt());
                        DialogicMtp3UserPart.this.sendResumeMessageToLocalUser(msgResume);
                        break;
                    }
                    case 5: {
                        Mtp3StatusCause cause;
                        if (buf.length < 9) {
                            logger.error((Object)"Error while parsing data from the Dialogic card: unsufficient data length for message MTP3_STATUS");
                            return;
                        }
                        int status = in.readUnsignedByte();
                        int affectedDpc = in.readInt();
                        short congestionLevel = in.readShort();
                        short unavailabiltyCause = in.readShort();
                        if (status == 1) {
                            switch (unavailabiltyCause) {
                                case 1: {
                                    cause = Mtp3StatusCause.UserPartUnavailability_UnequippedRemoteUser;
                                    break;
                                }
                                case 2: {
                                    cause = Mtp3StatusCause.UserPartUnavailability_InaccessibleRemoteUser;
                                    break;
                                }
                                default: {
                                    cause = Mtp3StatusCause.UserPartUnavailability_Unknown;
                                }
                            }
                            congestionLevel = 0;
                        } else {
                            cause = Mtp3StatusCause.SignallingNetworkCongested;
                            congestionLevel = 0;
                        }
                        Mtp3StatusPrimitive msgStatus = new Mtp3StatusPrimitive(affectedDpc, cause, (int)congestionLevel);
                        DialogicMtp3UserPart.this.sendStatusMessageToLocalUser(msgStatus);
                        break;
                    }
                    default: {
                        logger.error((Object)("Error while parsing system messages from the Dialogic card: unknown primitive type: " + type));
                        break;
                    }
                }
            }
            catch (IOException e) {
                logger.error((Object)("IOException while parsing system messages from the Dialogic card: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

