/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.hardware.dialogic;

import java.io.IOException;

public class InterProcessCommunicator {
    private static final String LIB_NAME = "mobicents-dialogic-linux";
    private int source;
    private int destination;
    private byte[] readBuffer = new byte[1000];

    public InterProcessCommunicator(int source, int destination) {
        this.source = source;
        this.destination = destination;
    }

    public byte[] read() {
        int len = this.receive(this.source, this.readBuffer);
        if (len == -1) {
            return null;
        }
        byte[] tempBuf = new byte[len];
        System.arraycopy(this.readBuffer, 0, tempBuf, 0, len);
        return tempBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] msg) throws IOException {
        InterProcessCommunicator interProcessCommunicator = this;
        synchronized (interProcessCommunicator) {
            int status = this.send(this.source, this.destination, msg);
            if (status != 0) {
                throw new IOException("Dialogic card: Can not send packet by GCT_send() method");
            }
            return status;
        }
    }

    private native int receive(int var1, byte[] var2);

    private native int send(int var1, int var2, byte[] var3);

    static {
        try {
            System.loadLibrary(LIB_NAME);
            System.out.println("Loaded library mobicents-dialogic-linux");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

