/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.api;

import java.util.Arrays;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;

public class MAPApplicationContext {
    private static long[] oidTemplate = new long[]{0L, 4L, 0L, 0L, 1L, 0L, 0L, 0L};
    private MAPApplicationContextName contextName;
    private MAPApplicationContextVersion contextVersion;

    private MAPApplicationContext(MAPApplicationContextName contextName, MAPApplicationContextVersion contextVersion) {
        this.contextName = contextName;
        this.contextVersion = contextVersion;
    }

    public long[] getOID() {
        long[] res = Arrays.copyOf(oidTemplate, oidTemplate.length);
        res[6] = this.contextName.getApplicationContextCode();
        res[7] = this.contextVersion.getVersion();
        return res;
    }

    public MAPApplicationContextName getApplicationContextName() {
        return this.contextName;
    }

    public MAPApplicationContextVersion getApplicationContextVersion() {
        return this.contextVersion;
    }

    public static MAPApplicationContext getInstance(MAPApplicationContextName contextName, MAPApplicationContextVersion contextVersion) {
        if (MAPApplicationContext.availableApplicationContextVersion(contextName, contextVersion.getVersion())) {
            return new MAPApplicationContext(contextName, contextVersion);
        }
        return null;
    }

    public static MAPApplicationContext getInstance(long[] oid) {
        if (oid == null || oid.length != oidTemplate.length) {
            return null;
        }
        for (int i1 = 0; i1 < oidTemplate.length - 2; ++i1) {
            if (oid[i1] == oidTemplate[i1]) continue;
            return null;
        }
        MAPApplicationContextName contextName = MAPApplicationContextName.getInstance(oid[6]);
        MAPApplicationContextVersion contextVersion = MAPApplicationContextVersion.getInstance(oid[7]);
        if (contextName == null || contextVersion == null) {
            return null;
        }
        if (!MAPApplicationContext.availableApplicationContextVersion(contextName, (int)oid[7])) {
            return null;
        }
        return new MAPApplicationContext(contextName, contextVersion);
    }

    public static boolean availableApplicationContextVersion(MAPApplicationContextName contextName, int contextVersion) {
        switch (contextName) {
            case networkUnstructuredSsContext: 
            case shortMsgAlertContext: {
                return contextVersion >= 1 && contextVersion <= 2;
            }
            case shortMsgMORelayContext: 
            case shortMsgMTRelayContext: 
            case shortMsgGatewayContext: {
                return contextVersion >= 1 && contextVersion <= 3;
            }
            case locationSvcEnquiryContext: {
                return contextVersion == 3;
            }
        }
        return false;
    }

    public static int getProtocolVersion(long[] oid) {
        if (oid == null || oid.length != 8) {
            return 0;
        }
        return (int)oid[7];
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MAPApplicationContext)) {
            return false;
        }
        MAPApplicationContext x = (MAPApplicationContext)obj;
        return this.contextName == x.contextName && this.contextVersion == x.contextVersion;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("MAPApplicationContext [Name=");
        s.append(this.contextName.toString());
        s.append(", Version=");
        s.append(this.contextVersion.toString());
        s.append(", Oid=");
        for (long l : this.getOID()) {
            s.append(l).append(", ");
        }
        s.append("]");
        return s.toString();
    }
}

