/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc. and/or its affiliates, and individual
 * contributors as indicated by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a full listing
 * of individual contributors.
 * 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU General Public License, v. 2.0.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License,
 * v. 2.0 along with this distribution; if not, write to the Free 
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */
package org.mobicents.protocols.ss7.map.api.primitives;

/**
 * @author amit bhayani
 * 
 */
public enum AlertingCategory {
	Category1((byte) 4), Category2((byte) 5), Category3((byte) 6), Category4((byte) 7), Category5((byte) 8);

	private final byte category;

	private AlertingCategory(byte category) {
		this.category = category;
	}

	public byte getCategory() {
		return this.category;
	}

	public static AlertingCategory getInstance(byte category) {
		switch (category) {
		case 4:
			return Category1;
		case 5:
			return Category2;
		case 6:
			return Category3;
		case 7:
			return Category4;
		case 8:
			return Category5;
		default:
			return null;
		}
	}
}
