/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map;

import org.mobicents.protocols.StartFailedException;
import org.mobicents.protocols.ss7.map.MAPProviderImpl;
import org.mobicents.protocols.ss7.map.api.MAPProvider;
import org.mobicents.protocols.ss7.map.api.MAPStack;
import org.mobicents.protocols.ss7.sccp.SccpProvider;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.TCAPStackImpl;
import org.mobicents.protocols.ss7.tcap.api.TCAPProvider;
import org.mobicents.protocols.ss7.tcap.api.TCAPStack;

public class MAPStackImpl
implements MAPStack {
    private TCAPStack tcapStack = null;
    private MAPProviderImpl mapProvider = null;
    private State state = State.IDLE;

    public MAPStackImpl(SccpProvider sccpPprovider, SccpAddress address) {
        this.tcapStack = new TCAPStackImpl(sccpPprovider, address);
        TCAPProvider tcapProvider = this.tcapStack.getProvider();
        this.mapProvider = new MAPProviderImpl(tcapProvider);
        this.state = State.CONFIGURED;
    }

    public MAPProvider getMAPProvider() {
        return this.mapProvider;
    }

    public void start() throws IllegalStateException, StartFailedException {
        if (this.state != State.CONFIGURED) {
            throw new IllegalStateException("Stack has not been configured or is already running!");
        }
        if (this.tcapStack != null) {
            this.tcapStack.start();
        }
        this.mapProvider.start();
        this.state = State.RUNNING;
    }

    public void stop() {
        if (this.state != State.RUNNING) {
            throw new IllegalStateException("Stack is not running!");
        }
        this.mapProvider.stop();
        if (this.tcapStack != null) {
            this.tcapStack.stop();
        }
        this.state = State.CONFIGURED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        IDLE,
        CONFIGURED,
        RUNNING;

    }
}

