/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.dialog;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.dialog.AddressNature;
import org.mobicents.protocols.ss7.map.api.dialog.AddressString;
import org.mobicents.protocols.ss7.map.api.dialog.NumberingPlan;

public class AddressStringImpl
implements AddressString {
    protected int NO_EXTENSION_MASK = 128;
    protected int NATURE_OF_ADD_IND_MASK = 112;
    protected int NUMBERING_PLAN_IND_MASK = 15;
    private int DIGIT_1_MASK = 15;
    private int DIGIT_2_MASK = 240;
    private AddressNature addressNature;
    private NumberingPlan numberingPlan;
    private String address;
    private boolean isExtension;

    public AddressStringImpl() {
    }

    public AddressStringImpl(AddressNature addressNature, NumberingPlan numberingPlan, String address) {
        this.addressNature = addressNature;
        this.numberingPlan = numberingPlan;
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public AddressNature getAddressNature() {
        return this.addressNature;
    }

    public NumberingPlan getNumberingPlan() {
        return this.numberingPlan;
    }

    public boolean isExtension() {
        return this.isExtension;
    }

    public void decode(AsnInputStream ansIS) throws MAPException, IOException {
        int nature = ansIS.read();
        this.isExtension = (nature & this.NO_EXTENSION_MASK) != 128;
        int natureOfAddInd = (nature & this.NATURE_OF_ADD_IND_MASK) >> 4;
        this.addressNature = AddressNature.getInstance((int)natureOfAddInd);
        int numbPlanInd = nature & this.NUMBERING_PLAN_IND_MASK;
        this.numberingPlan = NumberingPlan.getInstance((int)numbPlanInd);
        StringBuffer s = new StringBuffer();
        while (ansIS.available() > 0) {
            int b = ansIS.read();
            int digit1 = b & this.DIGIT_1_MASK;
            s.append(this.decodeNumber(digit1));
            int digit2 = (b & this.DIGIT_2_MASK) >> 4;
            if (digit2 == 15) continue;
            s.append(this.decodeNumber(digit2));
        }
        this.address = s.toString();
    }

    public void encode(AsnOutputStream asnOs) throws MAPException {
        int nature = 1;
        if (this.isExtension) {
            nature = 0;
        }
        nature <<= 7;
        nature |= this.addressNature.getIndicator() << 4;
        asnOs.write(nature |= this.numberingPlan.getIndicator());
        char[] chars = this.address.toCharArray();
        for (int i = 0; i < chars.length; i += 2) {
            int digit2;
            char a = chars[i];
            int digit1 = this.encodeNumber(a);
            if (i + 1 == chars.length) {
                digit2 = 15;
            } else {
                char b = chars[i + 1];
                digit2 = this.encodeNumber(b);
            }
            int digit = digit2 << 4 | digit1;
            asnOs.write(digit);
        }
    }

    private int encodeNumber(char c) throws MAPException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case '*': {
                return 10;
            }
            case '#': {
                return 11;
            }
            case 'a': {
                return 12;
            }
            case 'b': {
                return 13;
            }
            case 'c': {
                return 14;
            }
        }
        throw new MAPException("char should be between 0 - 9, *, #, a, b, c for Telephony Binary Coded Decimal String. Received " + c);
    }

    private char decodeNumber(int i) throws MAPException {
        switch (i) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return '*';
            }
            case 11: {
                return '#';
            }
            case 12: {
                return 'a';
            }
            case 13: {
                return 'b';
            }
            case 14: {
                return 'c';
            }
        }
        throw new MAPException("Integer should be between 0 - 15 for Telephony Binary Coded Decimal String. Received " + i);
    }
}

