/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.dialog;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.dialog.MAPRefuseInfo;
import org.mobicents.protocols.ss7.map.api.dialog.Reason;

public class MAPRefuseInfoImpl
implements MAPRefuseInfo {
    protected static final int MAP_REFUSE_INFO_TAG = 3;
    protected static final int REFUSE_TAG_CLASS = 2;
    protected static final boolean REFUSE_TAG_PC_CONSTRUCTED = false;
    private MAPDialog mapDialog = null;
    private Reason reason;

    public MAPDialog getMAPDialog() {
        return this.mapDialog;
    }

    public Reason getReason() {
        return this.reason;
    }

    public void setMAPDialog(MAPDialog mapDialog) {
        this.mapDialog = mapDialog;
    }

    public void setReason(Reason reason) {
        this.reason = reason;
    }

    public void decode(AsnInputStream ais) throws AsnException, IOException, MAPException {
        byte[] seqData = ais.readSequence();
        AsnInputStream localAis = new AsnInputStream((InputStream)new ByteArrayInputStream(seqData));
        while (localAis.available() > 0) {
            int tag = localAis.readTag();
            if (tag != 10) continue;
            int length = localAis.readLength();
            if (length != 1) {
                throw new MAPException("Expected length of MAP-RefuseInfo.Reason to be 1 but found " + length);
            }
            int reasonCode = localAis.read();
            this.reason = Reason.getReason((int)reasonCode);
        }
    }

    public void encode(AsnOutputStream asnOS) throws IOException, MAPException {
        byte[] data = new byte[]{10, 1, (byte)this.reason.getCode()};
        asnOS.writeTag(2, false, 3);
        asnOS.writeLength(data.length);
        asnOS.write(data);
    }
}

