/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.supplementary;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.mobicents.protocols.ss7.map.GSMCharset;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.service.supplementary.USSDString;

public class USSDStringImpl
implements USSDString {
    private String ussdString;
    private byte[] encodedString;
    private Charset charset;

    public USSDStringImpl(String ussdString, Charset charset) {
        this.ussdString = ussdString;
        this.charset = charset;
        if (this.charset == null) {
            this.charset = new GSMCharset("GSM", new String[0]);
        }
    }

    public USSDStringImpl(byte[] encodedString, Charset charset) {
        this.encodedString = encodedString;
        this.charset = charset;
        if (this.charset == null) {
            this.charset = new GSMCharset("GSM", new String[0]);
        }
    }

    public byte[] getEncodedString() {
        return this.encodedString;
    }

    public String getString() {
        return this.ussdString;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void decode() throws MAPException {
        if (this.encodedString == null) {
            throw new MAPException("encodedString byte[] is null");
        }
        ByteBuffer bb = ByteBuffer.wrap(this.encodedString);
        CharBuffer bf = this.charset.decode(bb);
        this.ussdString = bf.toString();
    }

    public void encode() throws MAPException {
        if (this.ussdString == null) {
            throw new MAPException("USSD String is null");
        }
        if (this.charset == null) {
            this.charset = new GSMCharset("GSM", new String[0]);
        }
        ByteBuffer bb = this.charset.encode(this.ussdString);
        this.encodedString = new byte[bb.limit()];
        int count = 0;
        while (bb.hasRemaining()) {
            this.encodedString[count++] = bb.get();
        }
    }
}

