/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.MAPDialogImpl;
import org.mobicents.protocols.ss7.map.MapServiceFactoryImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPDialogListener;
import org.mobicents.protocols.ss7.map.api.MAPDialogueAS;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPProvider;
import org.mobicents.protocols.ss7.map.api.MAPServiceListener;
import org.mobicents.protocols.ss7.map.api.MapServiceFactory;
import org.mobicents.protocols.ss7.map.api.dialog.AddressString;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAcceptInfo;
import org.mobicents.protocols.ss7.map.api.dialog.MAPCloseInfo;
import org.mobicents.protocols.ss7.map.api.dialog.MAPOpenInfo;
import org.mobicents.protocols.ss7.map.api.dialog.MAPProviderAbortInfo;
import org.mobicents.protocols.ss7.map.api.dialog.MAPProviderAbortReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortInfo;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ProcessUnstructuredSSIndication;
import org.mobicents.protocols.ss7.map.api.service.supplementary.USSDString;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSIndication;
import org.mobicents.protocols.ss7.map.dialog.AddressStringImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPAcceptInfoImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPCloseInfoImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPOpenInfoImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPProviderAbortInfoImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPUserAbortChoiceImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPUserAbortInfoImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.ProcessUnstructuredSSIndicationImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.UnstructuredSSIndicationImpl;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.api.TCAPException;
import org.mobicents.protocols.ss7.tcap.api.TCAPProvider;
import org.mobicents.protocols.ss7.tcap.api.TCAPSendException;
import org.mobicents.protocols.ss7.tcap.api.TCListener;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCBeginIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCContinueIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCEndIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCPAbortIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUniIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUserAbortIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUserAbortRequest;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.UserInformation;
import org.mobicents.protocols.ss7.tcap.asn.comp.Component;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.PAbortCauseType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResult;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResultLast;

public class MAPProviderImpl
implements MAPProvider,
TCListener {
    Logger loger = Logger.getLogger(MAPProviderImpl.class);
    private Set<MAPDialogListener> dialogListeners = new HashSet<MAPDialogListener>();
    private Set<MAPServiceListener> serviceListeners = new HashSet<MAPServiceListener>();
    private Map<Long, MAPDialogImpl> dialogs = new HashMap<Long, MAPDialogImpl>();
    private TCAPProvider tcapProvider = null;
    private final MapServiceFactory mapServiceFactory = new MapServiceFactoryImpl();

    public MAPProviderImpl(TCAPProvider tcapProvider) {
        this.tcapProvider = tcapProvider;
    }

    protected TCAPProvider getTCAPProvider() {
        return this.tcapProvider;
    }

    public void addMAPDialogListener(MAPDialogListener mapDialogListener) {
        this.dialogListeners.add(mapDialogListener);
    }

    public void addMAPServiceListener(MAPServiceListener mapServiceListener) {
        this.serviceListeners.add(mapServiceListener);
    }

    public MAPDialog createNewDialog(MAPApplicationContext appCntx, SccpAddress origAddress, AddressString origReference, SccpAddress destAddress, AddressString destReference) throws MAPException {
        Dialog tcapDialog;
        try {
            tcapDialog = this.tcapProvider.getNewDialog(origAddress, destAddress);
        }
        catch (TCAPException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
        MAPDialogImpl dialog = new MAPDialogImpl(appCntx, tcapDialog, this, origReference, destReference);
        this.dialogs.put(dialog.getDialogId(), dialog);
        return dialog;
    }

    public MapServiceFactory getMapServiceFactory() {
        return this.mapServiceFactory;
    }

    public void removeMAPDialogListener(MAPDialogListener mapDialogListener) {
        this.dialogListeners.remove(mapDialogListener);
    }

    public void removeMAPServiceListener(MAPServiceListener mapServiceListener) {
        this.serviceListeners.remove(mapServiceListener);
    }

    public void dialogReleased(Dialog arg0) {
    }

    private void unstructuredSSRequest(Parameter parameter, MAPDialogImpl mapDialogImpl, Long invokeId) throws MAPException {
        if (parameter.getTag() == 16) {
            Parameter[] parameters = parameter.getParameters();
            byte[] data = parameters[0].getData();
            byte ussd_DataCodingScheme = data[0];
            data = parameters[1].getData();
            USSDString ussdString = this.mapServiceFactory.createUSSDString(data, null);
            ussdString.decode();
            UnstructuredSSIndicationImpl unSSInd = new UnstructuredSSIndicationImpl(ussd_DataCodingScheme, ussdString);
            unSSInd.setInvokeId(invokeId);
            unSSInd.setMAPDialog(mapDialogImpl);
            for (MAPServiceListener serLis : this.serviceListeners) {
                serLis.onUnstructuredSSIndication((UnstructuredSSIndication)unSSInd);
            }
        } else {
            this.loger.error((Object)("Expected Parameter tag as SEQUENCE but received " + parameter.getTag()));
            throw new MAPException("Expected Parameter tag as SEQUENCE but received " + parameter.getTag());
        }
    }

    private void processUnstructuredSSRequest(Parameter parameter, MAPDialogImpl mapDialogImpl, Long invokeId) throws MAPException {
        if (parameter.getTag() == 16) {
            Parameter msisdnParam;
            Parameter[] parameters = parameter.getParameters();
            byte[] data = parameters[0].getData();
            byte ussd_DataCodingScheme = data[0];
            data = parameters[1].getData();
            USSDString ussdString = this.mapServiceFactory.createUSSDString(data, null);
            ussdString.decode();
            ProcessUnstructuredSSIndicationImpl procUnSSInd = new ProcessUnstructuredSSIndicationImpl(ussd_DataCodingScheme, ussdString);
            procUnSSInd.setInvokeId(invokeId);
            procUnSSInd.setMAPDialog(mapDialogImpl);
            if (parameters.length > 2 && (msisdnParam = parameters[2]).getTagClass() == 2 && msisdnParam.getTag() == 0) {
                byte[] msisdnData = msisdnParam.getData();
                AsnInputStream ansIS = new AsnInputStream((InputStream)new ByteArrayInputStream(msisdnData));
                AddressStringImpl msisdnAddStr = new AddressStringImpl();
                try {
                    msisdnAddStr.decode(ansIS);
                    procUnSSInd.setMSISDNAddressString(msisdnAddStr);
                }
                catch (IOException e) {
                    this.loger.error((Object)"Error while decoding the MSISDN AddressString ", (Throwable)e);
                }
            }
            for (MAPServiceListener serLis : this.serviceListeners) {
                serLis.onProcessUnstructuredSSIndication((ProcessUnstructuredSSIndication)procUnSSInd);
            }
        } else {
            this.loger.error((Object)("Expected Parameter tag as SEQUENCE but received " + parameter.getTag()));
            throw new MAPException("Expected Parameter tag as SEQUENCE but received " + parameter.getTag());
        }
    }

    public void onTCBegin(TCBeginIndication tcBeginIndication) {
        ApplicationContextName acn = tcBeginIndication.getApplicationContextName();
        Component[] comps = tcBeginIndication.getComponents();
        if (acn == null && comps == null) {
            this.loger.error((Object)"Both ApplicationContextName and Component[] are null. Send TC-U-ABORT to peer and not notifying the User");
            return;
        }
        if (acn == null) {
            this.loger.error((Object)"ApplicationContextName is null, we dont support deriving the version 1 application-context-name as we only support networkUnstructuredSsContextV2. Send TC-U-ABORT to peer and not notifying the User");
            return;
        }
        MAPApplicationContext mapAppCtx = MAPApplicationContext.getInstance((long[])acn.getOid());
        if (mapAppCtx == null) {
            StringBuffer s = new StringBuffer();
            s.append("Expected networkUnstructuredSsContextV2 ").append(MAPApplicationContext.getInstance((int)1).toString()).append(" But received");
            for (long l : acn.getOid()) {
                s.append(l).append(", ");
            }
            return;
        }
        UserInformation userInfo = tcBeginIndication.getUserInformation();
        if (userInfo != null) {
            if (!userInfo.isOid()) {
                this.loger.error((Object)"userInfo.isOid() check failed");
                return;
            }
            long[] oid = userInfo.getOidValue();
            MAPDialogueAS mapDialAs = MAPDialogueAS.getInstance((long[])oid);
            if (mapDialAs == null) {
                this.loger.error((Object)"Expected MAPDialogueAS.MAP_DialogueAS but is null");
                return;
            }
            if (!userInfo.isAsn()) {
                this.loger.error((Object)"userInfo.isAsn() check failed");
                return;
            }
            try {
                byte[] asnData = userInfo.getEncodeType();
                AsnInputStream ais = new AsnInputStream((InputStream)new ByteArrayInputStream(asnData));
                int tag = ais.readTag();
                if (tag != 0) {
                    return;
                }
                MAPDialogImpl mapDialogImpl = new MAPDialogImpl(mapAppCtx, tcBeginIndication.getDialog(), this);
                this.loger.info((Object)("TCBegin dialog = " + mapDialogImpl));
                mapDialogImpl.setMapAcceptInfoFired(true);
                this.dialogs.put(mapDialogImpl.getDialogId(), mapDialogImpl);
                MAPOpenInfoImpl mapOpenInfoImpl = new MAPOpenInfoImpl();
                mapOpenInfoImpl.setMAPDialog(mapDialogImpl);
                mapOpenInfoImpl.decode(ais);
                for (MAPDialogListener listener : this.dialogListeners) {
                    listener.onMAPOpenInfo((MAPOpenInfo)mapOpenInfoImpl);
                }
                if (comps != null) {
                    this.processComponents(mapDialogImpl, comps);
                }
                this.loger.info((Object)("TCBegin dialog..isMapAcceptInfoFired() = " + mapDialogImpl.isMapAcceptInfoFired()));
            }
            catch (AsnException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (MAPException e) {
                e.printStackTrace();
            }
        } else {
            this.loger.error((Object)"UserInfo is null");
            return;
        }
    }

    private void fireTCUAbort(Dialog tcapDialog, MAPDialogImpl mapDialog) throws MAPException {
        this.dialogs.remove(mapDialog.getDialogId());
        TCUserAbortRequest tcUserAbort = this.getTCAPProvider().getDialogPrimitiveFactory().createUAbort(tcapDialog);
        MAPProviderAbortInfoImpl mapProviderAbortInfo = new MAPProviderAbortInfoImpl();
        mapProviderAbortInfo.setMAPDialog(mapDialog);
        mapProviderAbortInfo.setMAPProviderAbortReason(MAPProviderAbortReason.abnormalDialogue);
        AsnOutputStream localasnOs = new AsnOutputStream();
        try {
            mapProviderAbortInfo.encode(localasnOs);
        }
        catch (IOException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
        UserInformation userInformation = TcapFactory.createUserInformation();
        userInformation.setOid(true);
        userInformation.setOidValue(MAPDialogueAS.MAP_DialogueAS.getOID());
        userInformation.setAsn(true);
        userInformation.setEncodeType(localasnOs.toByteArray());
        tcUserAbort.setUserInformation(userInformation);
        try {
            tcapDialog.send(tcUserAbort);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onMAPProviderAbortInfo((MAPProviderAbortInfo)mapProviderAbortInfo);
        }
    }

    public void onTCContinue(TCContinueIndication tcContinueIndication) {
        Component[] components;
        ApplicationContextName acn = tcContinueIndication.getApplicationContextName();
        Dialog tcapDialog = tcContinueIndication.getDialog();
        MAPDialogImpl mapDialogImpl = this.dialogs.get(tcapDialog.getDialogId());
        if (mapDialogImpl == null) {
            this.loger.error((Object)("MAP Dialog not found for Dialog Id " + tcapDialog.getDialogId()));
            return;
        }
        this.loger.info((Object)("onTCContinue MAPDialog = " + mapDialogImpl + " mapDialogImpl.isMapAcceptInfoFired() = " + mapDialogImpl.isMapAcceptInfoFired()));
        if (!mapDialogImpl.isMapAcceptInfoFired()) {
            if (acn == null) {
                try {
                    this.fireTCUAbort(tcapDialog, mapDialogImpl);
                }
                catch (MAPException e) {
                    this.loger.error((Object)e);
                }
            } else {
                MAPApplicationContext mapAcn = MAPApplicationContext.getInstance((long[])acn.getOid());
                if (mapAcn == null | mapAcn != mapDialogImpl.getAppCntx()) {
                    try {
                        this.fireTCUAbort(tcapDialog, mapDialogImpl);
                    }
                    catch (MAPException e) {
                        this.loger.error((Object)e);
                    }
                } else {
                    MAPAcceptInfoImpl mapAcceptInfo = new MAPAcceptInfoImpl();
                    mapAcceptInfo.setMAPDialog(mapDialogImpl);
                    for (MAPDialogListener listener : this.dialogListeners) {
                        listener.onMAPAcceptInfo((MAPAcceptInfo)mapAcceptInfo);
                    }
                    mapDialogImpl.setMapAcceptInfoFired(true);
                }
            }
        }
        if ((components = tcContinueIndication.getComponents()) != null) {
            this.processComponents(mapDialogImpl, components);
        }
    }

    public void onTCEnd(TCEndIndication tcEndIndication) {
        ApplicationContextName acn = tcEndIndication.getApplicationContextName();
        Dialog tcapDialog = tcEndIndication.getDialog();
        MAPDialogImpl mapDialogImpl = this.dialogs.remove(tcapDialog.getDialogId());
        if (mapDialogImpl == null) {
            this.loger.error((Object)("MAP Dialog not found for Dialog Id " + tcapDialog.getDialogId()));
            return;
        }
        MAPApplicationContext mapAcn = MAPApplicationContext.getInstance((long[])acn.getOid());
        if (mapAcn == null | mapAcn != mapDialogImpl.getAppCntx()) {
            MAPProviderAbortInfoImpl abortInfo = new MAPProviderAbortInfoImpl();
            abortInfo.setMAPDialog(mapDialogImpl);
            abortInfo.setMAPProviderAbortReason(MAPProviderAbortReason.abnormalDialogue);
            for (MAPDialogListener listener : this.dialogListeners) {
                listener.onMAPProviderAbortInfo((MAPProviderAbortInfo)abortInfo);
            }
            return;
        }
        Component[] components = tcEndIndication.getComponents();
        if (components != null) {
            this.processComponents(mapDialogImpl, components);
        }
        MAPCloseInfoImpl closeInfo = new MAPCloseInfoImpl();
        closeInfo.setMAPDialog(mapDialogImpl);
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onMAPCloseInfo((MAPCloseInfo)closeInfo);
        }
    }

    public void onTCUni(TCUniIndication arg0) {
    }

    public void onInvokeTimeout(Invoke arg0) {
    }

    public void onTCPAbort(TCPAbortIndication tcPAbortIndication) {
        Dialog tcapDialog = tcPAbortIndication.getDialog();
        MAPDialogImpl mapDialogImpl = this.dialogs.remove(tcapDialog.getDialogId());
        if (mapDialogImpl == null) {
            this.loger.error((Object)("MAP Dialog not found for Dialog Id " + tcapDialog.getDialogId()));
            return;
        }
        MAPProviderAbortInfoImpl prAbortInfoImpl = new MAPProviderAbortInfoImpl();
        prAbortInfoImpl.setMAPDialog(mapDialogImpl);
        PAbortCauseType pAbortCause = tcPAbortIndication.getPAbortCause();
        switch (pAbortCause) {
            case UnrecogniedMessageType: {
                prAbortInfoImpl.setMAPProviderAbortReason(MAPProviderAbortReason.abnormalDialogue);
                break;
            }
            case UnrecognizedTxID: {
                prAbortInfoImpl.setMAPProviderAbortReason(MAPProviderAbortReason.abnormalDialogue);
                break;
            }
            case BadlyFormattedTxPortion: {
                prAbortInfoImpl.setMAPProviderAbortReason(MAPProviderAbortReason.abnormalDialogue);
                break;
            }
            case IncorrectTxPortion: {
                prAbortInfoImpl.setMAPProviderAbortReason(MAPProviderAbortReason.abnormalDialogue);
                break;
            }
            case ResourceLimitation: {
                prAbortInfoImpl.setMAPProviderAbortReason(MAPProviderAbortReason.abnormalDialogue);
            }
        }
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onMAPProviderAbortInfo((MAPProviderAbortInfo)prAbortInfoImpl);
        }
    }

    public void onTCUserAbort(TCUserAbortIndication tcUserAbortIndication) {
        Dialog tcapDialog = tcUserAbortIndication.getDialog();
        MAPDialogImpl mapDialogImpl = this.dialogs.remove(tcapDialog.getDialogId());
        if (mapDialogImpl == null) {
            this.loger.error((Object)("MAP Dialog not found for Dialog Id " + tcapDialog.getDialogId()));
            return;
        }
        MAPUserAbortInfoImpl mapUserAbortInfoImpl = new MAPUserAbortInfoImpl();
        mapUserAbortInfoImpl.setMAPDialog(mapDialogImpl);
        MAPUserAbortChoiceImpl userAbortChoice = new MAPUserAbortChoiceImpl();
        userAbortChoice.setUserSpecificReason();
        mapUserAbortInfoImpl.setMAPUserAbortChoice(userAbortChoice);
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onMAPUserAbortInfo((MAPUserAbortInfo)mapUserAbortInfoImpl);
        }
    }

    private void processComponents(MAPDialogImpl mapDialogImpl, Component[] components) {
        for (Component c : components) {
            try {
                Parameter parameter;
                OperationCode oc;
                Invoke comp;
                ComponentType compType = c.getType();
                long invokeId = c.getInvokeId();
                if (compType == ComponentType.Invoke) {
                    comp = (Invoke)c;
                    oc = comp.getOperationCode();
                    parameter = comp.getParameter();
                } else if (compType == ComponentType.ReturnResult) {
                    comp = (ReturnResult)c;
                    oc = comp.getOperationCode();
                    parameter = comp.getParameter();
                } else {
                    if (compType != ComponentType.ReturnResultLast) continue;
                    comp = (ReturnResultLast)c;
                    oc = comp.getOperationCode();
                    parameter = comp.getParameter();
                }
                if (oc.getCode() == 59L) {
                    this.processUnstructuredSSRequest(parameter, mapDialogImpl, invokeId);
                    continue;
                }
                if (oc.getCode() == 60L) {
                    this.unstructuredSSRequest(parameter, mapDialogImpl, invokeId);
                    continue;
                }
                this.loger.error((Object)("Expected OC is MAPOperationCode.processUnstructuredSS_Request or MAPOperationCode.unstructuredSS_Request but received " + oc.getCode()));
                return;
            }
            catch (MAPException e) {
                e.printStackTrace();
            }
        }
    }

    public MAPDialog getMAPDialog(Long dialogId) {
        return this.dialogs.get(dialogId);
    }

    public void start() {
        this.tcapProvider.addTCListener((TCListener)this);
    }

    public void stop() {
        this.tcapProvider.removeTCListener((TCListener)this);
    }
}

