/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.dialog;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.dialog.AddressString;
import org.mobicents.protocols.ss7.map.api.dialog.MAPOpenInfo;
import org.mobicents.protocols.ss7.map.dialog.AddressStringImpl;

public class MAPOpenInfoImpl
implements MAPOpenInfo {
    protected static final int MAP_OPEN_INFO_TAG = 0;
    protected static final int DESTINATION_REF_TAG = 0;
    protected static final int ORIGINATION_REF_TAG = 1;
    protected static final int OPEN_INFO_TAG_CLASS = 2;
    protected static final boolean OPEN_INFO_TAG_PC_PRIMITIVE = true;
    protected static final boolean OPEN_INFO_TAG_PC_CONSTRUCTED = false;
    private MAPDialog mapDialog = null;
    private AddressString destReference;
    private AddressString origReference;

    public AddressString getDestReference() {
        return this.destReference;
    }

    public MAPDialog getMAPDialog() {
        return this.mapDialog;
    }

    public AddressString getOrigReference() {
        return this.origReference;
    }

    public void setDestReference(AddressString destReference) {
        this.destReference = destReference;
    }

    public void setMAPDialog(MAPDialog mapDialog) {
        this.mapDialog = mapDialog;
    }

    public void setOrigReference(AddressString origReference) {
        this.origReference = origReference;
    }

    public void decode(AsnInputStream ais) throws AsnException, IOException, MAPException {
        byte[] seqData = ais.readSequence();
        AsnInputStream localAis = new AsnInputStream((InputStream)new ByteArrayInputStream(seqData));
        while (localAis.available() > 0) {
            ByteArrayOutputStream outputStream;
            int tag = localAis.readTag();
            if (tag == 0) {
                outputStream = new ByteArrayOutputStream();
                localAis.readOctetString((OutputStream)outputStream);
                this.destReference = new AddressStringImpl();
                ((AddressStringImpl)this.destReference).decode(new AsnInputStream((InputStream)new ByteArrayInputStream(outputStream.toByteArray())));
                continue;
            }
            if (tag == 1) {
                outputStream = new ByteArrayOutputStream();
                localAis.readOctetString((OutputStream)outputStream);
                this.origReference = new AddressStringImpl();
                ((AddressStringImpl)this.origReference).decode(new AsnInputStream((InputStream)new ByteArrayInputStream(outputStream.toByteArray())));
                continue;
            }
            if (tag != 16) continue;
        }
    }

    public void encode(AsnOutputStream asnOS) throws IOException, MAPException {
        AsnOutputStream localAos = new AsnOutputStream();
        ((AddressStringImpl)this.destReference).encode(localAos);
        byte[] destAddData = localAos.toByteArray();
        localAos.reset();
        ((AddressStringImpl)this.origReference).encode(localAos);
        byte[] origAddData = localAos.toByteArray();
        localAos.reset();
        localAos.writeTag(2, true, 0);
        localAos.writeLength(destAddData.length);
        localAos.write(destAddData);
        localAos.writeTag(2, true, 1);
        localAos.writeLength(origAddData.length);
        localAos.write(origAddData);
        byte[] data = localAos.toByteArray();
        asnOS.writeTag(2, false, 0);
        asnOS.writeLength(data.length);
        asnOS.write(data);
    }
}

