/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.dialog;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortInfo;
import org.mobicents.protocols.ss7.map.api.dialog.ProcedureCancellationReason;
import org.mobicents.protocols.ss7.map.api.dialog.ResourceUnavailableReason;
import org.mobicents.protocols.ss7.map.dialog.MAPUserAbortChoiceImpl;

public class MAPUserAbortInfoImpl
implements MAPUserAbortInfo {
    protected static final int MAP_USER_ABORT_INFO_TAG = 4;
    protected static final int USER_ABORT_TAG_CLASS = 2;
    protected static final boolean USER_ABORT_TAG_PC_CONSTRUCTED = false;
    private MAPDialog mapDialog = null;
    private MAPUserAbortChoice mapUserAbortChoice = null;

    public MAPDialog getMAPDialog() {
        return this.mapDialog;
    }

    public MAPUserAbortChoice getMAPUserAbortChoice() {
        return this.mapUserAbortChoice;
    }

    public void setMAPDialog(MAPDialog mapDialog) {
        this.mapDialog = mapDialog;
    }

    public void setMAPUserAbortChoice(MAPUserAbortChoice mapUsrAbrtChoice) {
        this.mapUserAbortChoice = mapUsrAbrtChoice;
    }

    public void decode(AsnInputStream ais) throws AsnException, IOException, MAPException {
        byte[] seqData = ais.readSequence();
        AsnInputStream localAis = new AsnInputStream((InputStream)new ByteArrayInputStream(seqData));
        while (localAis.available() > 0) {
            int tag = localAis.readTag();
            MAPUserAbortChoiceImpl usAbrtChoice = new MAPUserAbortChoiceImpl();
            switch (tag) {
                case 0: {
                    int length = localAis.readLength();
                    if (length != 0) {
                        throw new AsnException("Null length should be 0 but is " + length);
                    }
                    usAbrtChoice.setUserSpecificReason();
                    break;
                }
                case 1: {
                    int length = localAis.readLength();
                    if (length != 0) {
                        throw new AsnException("Null length should be 0 but is " + length);
                    }
                    usAbrtChoice.setUserResourceLimitation();
                    break;
                }
                case 2: {
                    int length = localAis.readLength();
                    tag = localAis.readTag();
                    if (tag != 10) {
                        throw new AsnException("Expected ENUMERATED TAG for ResourceUnavailableReason but received " + tag);
                    }
                    length = localAis.readLength();
                    if (length != 1) {
                        throw new MAPException("Expected length of MAPUserAbortChoiceImpl.RESOURCE_UNAVAILABLE to be 1 but found " + length);
                    }
                    int code = localAis.read();
                    ResourceUnavailableReason resUnaReas = ResourceUnavailableReason.getInstance((int)code);
                    usAbrtChoice.setResourceUnavailableReason(resUnaReas);
                    break;
                }
                case 3: {
                    int length = localAis.readLength();
                    tag = localAis.readTag();
                    if (tag != 10) {
                        throw new AsnException("Expected ENUMERATED TAG for ResourceUnavailableReason but received " + tag);
                    }
                    length = localAis.readLength();
                    if (length != 1) {
                        throw new MAPException("Expected length of MAPUserAbortChoiceImpl.APPLICATION_PROCEDURE_CANCELLATION to be 1 but found " + length);
                    }
                    int code1 = localAis.read();
                    ProcedureCancellationReason procCanReasn = ProcedureCancellationReason.getInstance((int)code1);
                    usAbrtChoice.setProcedureCancellationReason(procCanReasn);
                }
            }
            this.setMAPUserAbortChoice(usAbrtChoice);
        }
    }

    public void encode(AsnOutputStream asnOS) throws IOException, MAPException {
        byte[] data = null;
        if (this.mapUserAbortChoice.isUserSpecificReason()) {
            data = new byte[]{0, 0};
        } else if (this.mapUserAbortChoice.isUserResourceLimitation()) {
            data = new byte[]{1, 0};
        } else if (this.mapUserAbortChoice.isResourceUnavailableReason()) {
            data = new byte[]{2, 3, 10, 1, (byte)this.mapUserAbortChoice.getResourceUnavailableReason().getCode()};
        } else if (this.mapUserAbortChoice.isProcedureCancellationReason()) {
            data = new byte[]{3, 3, 10, 1, (byte)this.mapUserAbortChoice.getProcedureCancellationReason().getCode()};
        }
        asnOS.writeTag(2, false, 4);
        asnOS.writeLength(data.length);
        asnOS.write(data);
    }
}

