/*
 * Decompiled with CFR 0.152.
 */
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.mobicents.protocols.ss7.indicator.RoutingIndicator;
import org.mobicents.protocols.ss7.map.MAPStackImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPDialogListener;
import org.mobicents.protocols.ss7.map.api.MAPParameterFactory;
import org.mobicents.protocols.ss7.map.api.MAPProvider;
import org.mobicents.protocols.ss7.map.api.MAPStack;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortProviderReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortSource;
import org.mobicents.protocols.ss7.map.api.dialog.MAPNoticeProblemDiagnostic;
import org.mobicents.protocols.ss7.map.api.dialog.MAPProviderError;
import org.mobicents.protocols.ss7.map.api.dialog.MAPRefuseReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.primitives.AddressNature;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.primitives.NumberingPlan;
import org.mobicents.protocols.ss7.map.api.primitives.USSDString;
import org.mobicents.protocols.ss7.map.api.service.supplementary.MAPDialogSupplementary;
import org.mobicents.protocols.ss7.map.api.service.supplementary.MAPServiceSupplementaryListener;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ProcessUnstructuredSSRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ProcessUnstructuredSSResponseIndication;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSNotifyRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSResponseIndication;
import org.mobicents.protocols.ss7.sccp.SccpProvider;
import org.mobicents.protocols.ss7.sccp.SccpStack;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;

public class MAPExample
implements MAPDialogListener,
MAPServiceSupplementaryListener {
    private MAPStack mapStack;
    private MAPProvider mapProvider;
    MAPParameterFactory servFact;
    SccpAddress destAddress = null;
    AddressString destReference = this.servFact.createAddressString(AddressNature.international_number, NumberingPlan.land_mobile, "204208300008002");
    SccpAddress origAddress = null;
    AddressString origReference = this.servFact.createAddressString(AddressNature.international_number, NumberingPlan.ISDN, "31628968300");

    MAPExample(SccpProvider sccpPprovider, SccpAddress address, SccpAddress remoteAddress) {
        this.origAddress = address;
        this.destAddress = remoteAddress;
        this.mapStack = new MAPStackImpl(sccpPprovider, 8);
        this.mapProvider = this.mapStack.getMAPProvider();
        this.servFact = this.mapProvider.getMAPParameterFactory();
        this.mapProvider.addMAPDialogListener((MAPDialogListener)this);
        this.mapProvider.getMAPServiceSupplementary().addMAPServiceListener((MAPServiceSupplementaryListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SccpProvider getSccpProvider() throws NamingException {
        InitialContext ctx = new InitialContext();
        try {
            String providerJndiName = "/mobicents/ss7/sccp";
            SccpProvider sccpProvider = ((SccpStack)ctx.lookup(providerJndiName)).getSccpProvider();
            return sccpProvider;
        }
        finally {
            ctx.close();
        }
    }

    private static SccpAddress createLocalAddress() {
        return new SccpAddress(RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN, 1, null, 8);
    }

    private static SccpAddress createRemoteAddress() {
        return new SccpAddress(RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN, 2, null, 8);
    }

    public void run() throws Exception {
        this.mapProvider.getMAPServiceSupplementary().acivate();
        MAPDialogSupplementary mapDialog = this.mapProvider.getMAPServiceSupplementary().createNewDialog(MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.networkUnstructuredSsContext, (MAPApplicationContextVersion)MAPApplicationContextVersion.version2), this.destAddress, this.destReference, this.origAddress, this.origReference);
        byte ussdDataCodingScheme = 15;
        USSDString ussdString = this.servFact.createUSSDString("*125*+31628839999#", null);
        ISDNAddressString msisdn = this.servFact.createISDNAddressString(AddressNature.international_number, NumberingPlan.ISDN, "31628838002");
        mapDialog.addProcessUnstructuredSSRequest(ussdDataCodingScheme, ussdString, null, msisdn);
        mapDialog.send();
    }

    public static void main(String[] args) throws Exception {
        SccpProvider sccpProvider = MAPExample.getSccpProvider();
        SccpAddress localAddress = MAPExample.createLocalAddress();
        SccpAddress remoteAddress = MAPExample.createRemoteAddress();
        MAPExample example = new MAPExample(sccpProvider, localAddress, remoteAddress);
        example.run();
    }

    public void onDialogRequest(MAPDialog mapDialog, AddressString destReference, AddressString origReference, MAPExtensionContainer extensionContainer) {
    }

    public void onDialogAccept(MAPDialog mapDialog, MAPExtensionContainer extensionContainer) {
    }

    public void onDialogReject(MAPDialog mapDialog, MAPRefuseReason refuseReason, MAPProviderError providerError, ApplicationContextName alternativeApplicationContext, MAPExtensionContainer extensionContainer) {
    }

    public void onDialogUserAbort(MAPDialog mapDialog, MAPUserAbortChoice userReason, MAPExtensionContainer extensionContainer) {
    }

    public void onDialogProviderAbort(MAPDialog mapDialog, MAPAbortProviderReason abortProviderReason, MAPAbortSource abortSource, MAPExtensionContainer extensionContainer) {
    }

    public void onDialogClose(MAPDialog mapDialog) {
    }

    public void onDialogDelimiter(MAPDialog mapDialog) {
    }

    public void onDialogNotice(MAPDialog mapDialog, MAPNoticeProblemDiagnostic noticeProblemDiagnostic) {
    }

    public void onDialogResease(MAPDialog mapDialog) {
    }

    public void onDialogTimeout(MAPDialog mapDialog) {
    }

    public void onErrorComponent(MAPDialog mapDialog, Long invokeId, MAPErrorMessage mapErrorMessage) {
    }

    public void onProviderErrorComponent(MAPDialog mapDialog, Long invokeId, MAPProviderError providerError) {
    }

    public void onRejectComponent(MAPDialog mapDialog, Long invokeId, Problem problem) {
    }

    public void onInvokeTimeout(MAPDialog mapDialog, Long invoke) {
    }

    public void onProcessUnstructuredSSRequestIndication(ProcessUnstructuredSSRequestIndication procUnstrReqInd) {
    }

    public void onProcessUnstructuredSSResponseIndication(ProcessUnstructuredSSResponseIndication procUnstrResInd) {
    }

    public void onUnstructuredSSRequestIndication(UnstructuredSSRequestIndication unstrReqInd) {
    }

    public void onUnstructuredSSResponseIndication(UnstructuredSSResponseIndication unstrResInd) {
    }

    public void onUnstructuredSSNotifyRequestIndication(UnstructuredSSNotifyRequestIndication unstrNotifyInd) {
    }
}

