/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.MAPDialogState;
import org.mobicents.protocols.ss7.map.MAPProviderImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPServiceBase;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.mobicents.protocols.ss7.map.api.dialog.Reason;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageImpl;
import org.mobicents.protocols.ss7.tcap.api.TCAPException;
import org.mobicents.protocols.ss7.tcap.api.TCAPSendException;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCBeginRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCContinueRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCEndRequest;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.Component;
import org.mobicents.protocols.ss7.tcap.asn.comp.ErrorCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;
import org.mobicents.protocols.ss7.tcap.asn.comp.Reject;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnError;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResult;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResultLast;

public abstract class MAPDialogImpl
implements MAPDialog {
    private static final Logger logger = Logger.getLogger(MAPDialogImpl.class);
    private Object userObject;
    protected Dialog tcapDialog = null;
    protected MAPProviderImpl mapProviderImpl = null;
    protected MAPServiceBase mapService = null;
    protected MAPApplicationContext appCntx;
    protected AddressString destReference;
    protected AddressString origReference;
    protected MAPExtensionContainer extContainer = null;
    protected MAPDialogState state = MAPDialogState.Idle;
    protected Boolean normalDialogShutDown = false;
    private Set<Long> incomingInvokeList = new HashSet<Long>();

    protected MAPDialogImpl(MAPApplicationContext appCntx, Dialog tcapDialog, MAPProviderImpl mapProviderImpl, MAPServiceBase mapService, AddressString origReference, AddressString destReference) {
        this.appCntx = appCntx;
        this.tcapDialog = tcapDialog;
        this.mapProviderImpl = mapProviderImpl;
        this.mapService = mapService;
        this.destReference = destReference;
        this.origReference = origReference;
    }

    public void keepAlive() {
        this.tcapDialog.keepAlive();
    }

    public Long getDialogId() {
        return this.tcapDialog.getDialogId();
    }

    public MAPServiceBase getService() {
        return this.mapService;
    }

    public Dialog getTcapDialog() {
        return this.tcapDialog;
    }

    public void release() {
        this.setNormalDialogShutDown();
        this.setState(MAPDialogState.Expunged);
        if (this.tcapDialog != null) {
            this.tcapDialog.release();
        }
    }

    public void setExtentionContainer(MAPExtensionContainer extContainer) {
        this.extContainer = extContainer;
    }

    protected void setNormalDialogShutDown() {
        this.normalDialogShutDown = true;
    }

    protected Boolean getNormalDialogShutDown() {
        return this.normalDialogShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addIncomingInvokeId(Long invokeId) {
        Set<Long> set = this.incomingInvokeList;
        synchronized (set) {
            if (this.incomingInvokeList.contains(invokeId)) {
                return false;
            }
            this.incomingInvokeList.add(invokeId);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIncomingInvokeId(Long invokeId) {
        Set<Long> set = this.incomingInvokeList;
        synchronized (set) {
            this.incomingInvokeList.remove(invokeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean checkIncomingInvokeIdExists(Long invokeId) {
        Set<Long> set = this.incomingInvokeList;
        synchronized (set) {
            return this.incomingInvokeList.contains(invokeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(MAPUserAbortChoice mapUserAbortChoice) throws MAPException {
        MAPDialogImpl mAPDialogImpl = this;
        synchronized (mAPDialogImpl) {
            if (this.getState() == MAPDialogState.Expunged || this.getState() == MAPDialogState.Idle) {
                this.setState(MAPDialogState.Expunged);
                return;
            }
            this.setNormalDialogShutDown();
            this.mapProviderImpl.fireTCAbortUser(this.getTcapDialog(), mapUserAbortChoice, this.extContainer);
            this.extContainer = null;
            this.setState(MAPDialogState.Expunged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refuse(Reason reason) throws MAPException {
        MAPDialogImpl mAPDialogImpl = this;
        synchronized (mAPDialogImpl) {
            if (this.getState() != MAPDialogState.InitialReceived) {
                throw new MAPException("Refuse can be called in the Dialog InitialReceived state");
            }
            this.setNormalDialogShutDown();
            this.mapProviderImpl.fireTCAbortRefused(this.getTcapDialog(), reason, this.extContainer);
            this.extContainer = null;
            this.setState(MAPDialogState.Expunged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean prearrangedEnd) throws MAPException {
        MAPDialogImpl mAPDialogImpl = this;
        synchronized (mAPDialogImpl) {
            switch (this.tcapDialog.getState()) {
                case InitialReceived: {
                    ApplicationContextName acn = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    this.setNormalDialogShutDown();
                    this.mapProviderImpl.fireTCEnd(this.getTcapDialog(), true, prearrangedEnd, acn, this.extContainer);
                    this.extContainer = null;
                    this.setState(MAPDialogState.Expunged);
                    break;
                }
                case Active: {
                    this.setNormalDialogShutDown();
                    this.mapProviderImpl.fireTCEnd(this.getTcapDialog(), false, prearrangedEnd, null, null);
                    this.setState(MAPDialogState.Expunged);
                    break;
                }
                case Idle: {
                    throw new MAPException("Awaiting TC-BEGIN to be sent, can not send another dialog initiating primitive!");
                }
                case InitialSent: {
                    throw new MAPException("Awaiting TC-BEGIN response, can not send another dialog initiating primitive!");
                }
                case Expunged: {
                    throw new MAPException("Dialog has been terminated, can not send primitives!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() throws MAPException {
        MAPDialogImpl mAPDialogImpl = this;
        synchronized (mAPDialogImpl) {
            switch (this.tcapDialog.getState()) {
                case Idle: {
                    ApplicationContextName acn = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    this.mapProviderImpl.fireTCBegin(this.getTcapDialog(), acn, this.destReference, this.origReference, this.extContainer);
                    this.extContainer = null;
                    this.setState(MAPDialogState.InitialSent);
                    break;
                }
                case Active: {
                    this.mapProviderImpl.fireTCContinue(this.getTcapDialog(), false, null, null);
                    break;
                }
                case InitialReceived: {
                    ApplicationContextName acn1 = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    this.mapProviderImpl.fireTCContinue(this.getTcapDialog(), true, acn1, this.extContainer);
                    this.extContainer = null;
                    this.setState(MAPDialogState.Active);
                    break;
                }
                case InitialSent: {
                    throw new MAPException("Awaiting TC-BEGIN response, can not send another dialog initiating primitive!");
                }
                case Expunged: {
                    throw new MAPException("Dialog has been terminated, can not send primitives!");
                }
            }
        }
    }

    public MAPApplicationContext getApplicationContext() {
        return this.appCntx;
    }

    public MAPDialogState getState() {
        return this.state;
    }

    protected synchronized void setState(MAPDialogState newState) {
        if (this.state == MAPDialogState.Expunged) {
            return;
        }
        this.state = newState;
        if (newState == MAPDialogState.Expunged) {
            this.mapProviderImpl.removeDialog(this.tcapDialog.getDialogId());
            this.mapProviderImpl.deliverDialogResease(this);
        }
    }

    public void sendInvokeComponent(Invoke invoke) throws MAPException {
        try {
            this.tcapDialog.sendComponent((Component)invoke);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    public void sendReturnResultComponent(ReturnResult returnResult) throws MAPException {
        try {
            this.tcapDialog.sendComponent((Component)returnResult);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    public void sendReturnResultLastComponent(ReturnResultLast returnResultLast) throws MAPException {
        this.removeIncomingInvokeId(returnResultLast.getInvokeId());
        try {
            this.tcapDialog.sendComponent((Component)returnResultLast);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    public void sendErrorComponent(Long invokeId, MAPErrorMessage mem) throws MAPException {
        MAPErrorMessageImpl mapErrorMessage = (MAPErrorMessageImpl)mem;
        this.removeIncomingInvokeId(invokeId);
        ReturnError returnError = this.mapProviderImpl.getTCAPProvider().getComponentPrimitiveFactory().createTCReturnErrorRequest();
        try {
            returnError.setInvokeId(invokeId);
            ErrorCode ec = TcapFactory.createErrorCode();
            ec.setLocalErrorCode(mapErrorMessage.getErrorCode());
            returnError.setErrorCode(ec);
            AsnOutputStream aos = new AsnOutputStream();
            mapErrorMessage.encodeData(aos);
            byte[] buf = aos.toByteArray();
            if (buf.length != 0) {
                Parameter p = this.mapProviderImpl.getTCAPProvider().getComponentPrimitiveFactory().createParameter();
                p.setTagClass(mapErrorMessage.getTagClass());
                p.setPrimitive(mapErrorMessage.getIsPrimitive());
                p.setTag(mapErrorMessage.getTag());
                p.setData(buf);
                returnError.setParameter(p);
            }
            this.tcapDialog.sendComponent((Component)returnError);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    public void sendRejectComponent(Long invokeId, Problem problem) throws MAPException {
        if (invokeId != null && problem != null && problem.getInvokeProblemType() != null) {
            this.removeIncomingInvokeId(invokeId);
        }
        Reject reject = this.mapProviderImpl.getTCAPProvider().getComponentPrimitiveFactory().createTCRejectRequest();
        try {
            reject.setInvokeId(invokeId);
            reject.setProblem(problem);
            this.tcapDialog.sendComponent((Component)reject);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    public void resetInvokeTimer(Long invokeId) throws MAPException {
        try {
            this.getTcapDialog().resetTimer(invokeId);
        }
        catch (TCAPException e) {
            throw new MAPException("TCAPException occure: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean cancelInvocation(Long invokeId) throws MAPException {
        try {
            return this.getTcapDialog().cancelInvocation(invokeId);
        }
        catch (TCAPException e) {
            throw new MAPException("TCAPException occure: " + e.getMessage(), (Throwable)e);
        }
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public int getMaxUserDataLength() {
        return this.getTcapDialog().getMaxUserDataLength();
    }

    public int getMessageUserDataLengthOnSend() throws MAPException {
        try {
            switch (this.tcapDialog.getState()) {
                case Idle: {
                    ApplicationContextName acn = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    TCBeginRequest tb = this.mapProviderImpl.encodeTCBegin(this.getTcapDialog(), acn, this.destReference, this.origReference, this.extContainer);
                    return this.tcapDialog.getDataLength(tb);
                }
                case Active: {
                    TCContinueRequest tc = this.mapProviderImpl.encodeTCContinue(this.getTcapDialog(), false, null, null);
                    return this.tcapDialog.getDataLength(tc);
                }
                case InitialReceived: {
                    ApplicationContextName acn1 = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    TCContinueRequest tc = this.mapProviderImpl.encodeTCContinue(this.getTcapDialog(), true, acn1, this.extContainer);
                    return this.tcapDialog.getDataLength(tc);
                }
            }
        }
        catch (TCAPSendException e) {
            throw new MAPException("TCAPSendException when getMessageUserDataLengthOnSend", (Throwable)e);
        }
        throw new MAPException("Bad TCAP Dialog state: " + this.tcapDialog.getState());
    }

    public int getMessageUserDataLengthOnClose(boolean prearrangedEnd) throws MAPException {
        try {
            switch (this.tcapDialog.getState()) {
                case InitialReceived: {
                    ApplicationContextName acn = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    TCEndRequest te = this.mapProviderImpl.encodeTCEnd(this.getTcapDialog(), true, prearrangedEnd, acn, this.extContainer);
                    return this.tcapDialog.getDataLength(te);
                }
                case Active: {
                    TCEndRequest te = this.mapProviderImpl.encodeTCEnd(this.getTcapDialog(), false, prearrangedEnd, null, null);
                    return this.tcapDialog.getDataLength(te);
                }
            }
        }
        catch (TCAPSendException e) {
            throw new MAPException("TCAPSendException when getMessageUserDataLengthOnSend", (Throwable)e);
        }
        throw new MAPException("Bad TCAP Dialog state: " + this.tcapDialog.getState());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DialogId=").append(this.getDialogId()).append("MAPDialogState=").append((Object)this.getState()).append("MAPApplicationContext=").append(this.appCntx).append("TCAPDialogState=").append(this.tcapDialog.getState());
        return sb.toString();
    }
}

