/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.MAPDialogImpl;
import org.mobicents.protocols.ss7.map.MAPDialogState;
import org.mobicents.protocols.ss7.map.MAPParameterFactoryImpl;
import org.mobicents.protocols.ss7.map.MAPServiceBaseImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPDialogListener;
import org.mobicents.protocols.ss7.map.api.MAPDialogueAS;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParameterFactory;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPProvider;
import org.mobicents.protocols.ss7.map.api.MAPServiceBase;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortProviderReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortSource;
import org.mobicents.protocols.ss7.map.api.dialog.MAPNoticeProblemDiagnostic;
import org.mobicents.protocols.ss7.map.api.dialog.MAPProviderAbortReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPProviderError;
import org.mobicents.protocols.ss7.map.api.dialog.MAPRefuseReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.mobicents.protocols.ss7.map.api.dialog.Reason;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckData;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageFactory;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.lsm.MAPServiceLsm;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPServiceSms;
import org.mobicents.protocols.ss7.map.api.service.supplementary.MAPServiceSupplementary;
import org.mobicents.protocols.ss7.map.dialog.MAPAcceptInfoImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPCloseInfoImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPOpenInfoImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPProviderAbortInfoImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPRefuseInfoImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPUserAbortInfoImpl;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageFactoryImpl;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageImpl;
import org.mobicents.protocols.ss7.map.service.lsm.MAPServiceLsmImpl;
import org.mobicents.protocols.ss7.map.service.sms.MAPServiceSmsImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.MAPServiceSupplementaryImpl;
import org.mobicents.protocols.ss7.tcap.api.TCAPProvider;
import org.mobicents.protocols.ss7.tcap.api.TCAPSendException;
import org.mobicents.protocols.ss7.tcap.api.TCListener;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCBeginIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCBeginRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCContinueIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCContinueRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCEndIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCEndRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCPAbortIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUniIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUserAbortIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUserAbortRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TerminationType;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.DialogServiceProviderType;
import org.mobicents.protocols.ss7.tcap.asn.DialogServiceUserType;
import org.mobicents.protocols.ss7.tcap.asn.InvokeImpl;
import org.mobicents.protocols.ss7.tcap.asn.ResultSourceDiagnostic;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.UserInformation;
import org.mobicents.protocols.ss7.tcap.asn.comp.Component;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.ErrorCodeType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.InvokeProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCodeType;
import org.mobicents.protocols.ss7.tcap.asn.comp.PAbortCauseType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;
import org.mobicents.protocols.ss7.tcap.asn.comp.ProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Reject;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnError;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnErrorProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResult;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResultLast;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResultProblemType;

public class MAPProviderImpl
implements MAPProvider,
TCListener {
    protected Logger loger = Logger.getLogger(MAPProviderImpl.class);
    private Set<MAPDialogListener> dialogListeners = new HashSet<MAPDialogListener>();
    protected Map<Long, MAPDialogImpl> dialogs = new HashMap<Long, MAPDialogImpl>();
    private TCAPProvider tcapProvider = null;
    private final MAPParameterFactory MAPParameterFactory = new MAPParameterFactoryImpl();
    private final MAPErrorMessageFactory mapErrorMessageFactory = new MAPErrorMessageFactoryImpl();
    protected Set<MAPServiceBase> mapServices = new HashSet<MAPServiceBase>();
    private final MAPServiceSupplementary mapServiceSupplementary = new MAPServiceSupplementaryImpl(this);
    private final MAPServiceSms mapServiceSms = new MAPServiceSmsImpl(this);
    private final MAPServiceLsm mapServiceLsm = new MAPServiceLsmImpl(this);

    public MAPProviderImpl(TCAPProvider tcapProvider) {
        this.tcapProvider = tcapProvider;
        this.mapServices.add((MAPServiceBase)this.mapServiceSupplementary);
        this.mapServices.add((MAPServiceBase)this.mapServiceSms);
        this.mapServices.add((MAPServiceBase)this.mapServiceLsm);
    }

    public TCAPProvider getTCAPProvider() {
        return this.tcapProvider;
    }

    public MAPServiceSupplementary getMAPServiceSupplementary() {
        return this.mapServiceSupplementary;
    }

    public MAPServiceSms getMAPServiceSms() {
        return this.mapServiceSms;
    }

    public MAPServiceLsm getMAPServiceLsm() {
        return this.mapServiceLsm;
    }

    public void addMAPDialogListener(MAPDialogListener mapDialogListener) {
        this.dialogListeners.add(mapDialogListener);
    }

    public MAPParameterFactory getMAPParameterFactory() {
        return this.MAPParameterFactory;
    }

    public MAPErrorMessageFactory getMAPErrorMessageFactory() {
        return this.mapErrorMessageFactory;
    }

    public void removeMAPDialogListener(MAPDialogListener mapDialogListener) {
        this.dialogListeners.remove(mapDialogListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MAPDialog getMAPDialog(Long dialogId) {
        Map<Long, MAPDialogImpl> map = this.dialogs;
        synchronized (map) {
            return this.dialogs.get(dialogId);
        }
    }

    public void start() {
        this.tcapProvider.addTCListener((TCListener)this);
    }

    public void stop() {
        this.tcapProvider.removeTCListener((TCListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDialog(MAPDialogImpl dialog) {
        Map<Long, MAPDialogImpl> map = this.dialogs;
        synchronized (map) {
            this.dialogs.put(dialog.getDialogId(), dialog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDialog(Long dialogId) {
        Map<Long, MAPDialogImpl> map = this.dialogs;
        synchronized (map) {
            this.dialogs.remove(dialogId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTCBegin(TCBeginIndication tcBeginIndication) {
        MAPDialogImpl mapDialogImpl;
        ApplicationContextName acn = tcBeginIndication.getApplicationContextName();
        Component[] comps = tcBeginIndication.getComponents();
        if (acn == null && comps == null) {
            this.loger.error((Object)String.format("Received TCBeginIndication=%s, both ApplicationContextName and Component[] are null. Send TC-U-ABORT to peer and not notifying the User", tcBeginIndication));
            try {
                this.fireTCAbortV1(tcBeginIndication.getDialog());
            }
            catch (MAPException e) {
                this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
            }
            return;
        }
        MAPApplicationContext mapAppCtx = null;
        MAPServiceBase perfSer = null;
        if (acn == null) {
            OperationCode oc;
            Invoke invoke = null;
            int operationCode = -1;
            for (Component c : comps) {
                if (c.getType() != ComponentType.Invoke) continue;
                invoke = (Invoke)c;
                break;
            }
            if (invoke != null && (oc = invoke.getOperationCode()) != null && oc.getOperationType() == OperationCodeType.Local) {
                operationCode = (int)oc.getLocalOperationCode().longValue();
            }
            if (operationCode != -1) {
                for (MAPServiceBase ser : this.mapServices) {
                    MAPApplicationContext ac = ((MAPServiceBaseImpl)ser).getMAPv1ApplicationContext(operationCode, invoke);
                    if (ac == null) continue;
                    perfSer = ser;
                    mapAppCtx = ac;
                    break;
                }
            }
            if (mapAppCtx == null) {
                try {
                    this.fireTCAbortV1(tcBeginIndication.getDialog());
                    return;
                }
                catch (MAPException e) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                }
            }
        } else {
            if (MAPApplicationContext.getProtocolVersion((long[])acn.getOid()) < 2) {
                this.loger.error((Object)"Bad version of ApplicationContext if ApplicationContext exists. Must be 2 or greater");
                try {
                    this.fireTCAbortProvider(tcBeginIndication.getDialog(), MAPProviderAbortReason.abnormalDialogue, null);
                }
                catch (MAPException e) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                }
                return;
            }
            mapAppCtx = MAPApplicationContext.getInstance((long[])acn.getOid());
            if (mapAppCtx == null) {
                StringBuffer s = new StringBuffer();
                s.append("Unrecognizable ApplicationContextName is received: ");
                for (long l : acn.getOid()) {
                    s.append(l).append(", ");
                }
                this.loger.error((Object)s.toString());
                try {
                    this.fireTCAbortACNNotSupported(tcBeginIndication.getDialog(), null, null);
                }
                catch (MAPException e) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                }
                return;
            }
        }
        AddressString destReference = null;
        AddressString origReference = null;
        MAPExtensionContainer extensionContainer = null;
        UserInformation userInfo = tcBeginIndication.getUserInformation();
        if (userInfo != null) {
            MAPOpenInfoImpl mapOpenInfoImpl = new MAPOpenInfoImpl();
            if (!userInfo.isOid()) {
                this.loger.error((Object)"When parsing TC-BEGIN: userInfo.isOid() check failed");
                try {
                    this.fireTCAbortProvider(tcBeginIndication.getDialog(), MAPProviderAbortReason.abnormalDialogue, null);
                }
                catch (MAPException e) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                }
                return;
            }
            long[] oid = userInfo.getOidValue();
            MAPDialogueAS mapDialAs = MAPDialogueAS.getInstance((long[])oid);
            if (mapDialAs == null) {
                this.loger.error((Object)"When parsing TC-BEGIN: Expected MAPDialogueAS.MAP_DialogueAS but is null");
                try {
                    this.fireTCAbortProvider(tcBeginIndication.getDialog(), MAPProviderAbortReason.abnormalDialogue, null);
                }
                catch (MAPException e) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                }
                return;
            }
            if (!userInfo.isAsn()) {
                this.loger.error((Object)"When parsing TC-BEGIN: userInfo.isAsn() check failed");
                try {
                    this.fireTCAbortProvider(tcBeginIndication.getDialog(), MAPProviderAbortReason.abnormalDialogue, null);
                }
                catch (MAPException e) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                }
                return;
            }
            try {
                byte[] asnData = userInfo.getEncodeType();
                AsnInputStream ais = new AsnInputStream(asnData);
                int tag = ais.readTag();
                if (tag != 0) {
                    this.loger.error((Object)"When parsing TC-BEGIN: MAP-OPEN dialog PDU must be received");
                    try {
                        this.fireTCAbortProvider(tcBeginIndication.getDialog(), MAPProviderAbortReason.abnormalDialogue, null);
                    }
                    catch (MAPException e) {
                        this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                    }
                    return;
                }
                mapOpenInfoImpl.decodeAll(ais);
                destReference = mapOpenInfoImpl.getDestReference();
                origReference = mapOpenInfoImpl.getOrigReference();
                extensionContainer = mapOpenInfoImpl.getExtensionContainer();
            }
            catch (AsnException e) {
                e.printStackTrace();
                this.loger.error((Object)("AsnException when parsing MAP-OPEN Pdu: " + e.getMessage()), (Throwable)e);
                try {
                    this.fireTCAbortProvider(tcBeginIndication.getDialog(), MAPProviderAbortReason.abnormalDialogue, null);
                }
                catch (MAPException e1) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e1);
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.loger.error((Object)("IOException when parsing MAP-OPEN Pdu: " + e.getMessage()));
                try {
                    this.fireTCAbortProvider(tcBeginIndication.getDialog(), MAPProviderAbortReason.abnormalDialogue, null);
                }
                catch (MAPException e1) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e1);
                }
                return;
            }
            catch (MAPParsingComponentException e) {
                e.printStackTrace();
                this.loger.error((Object)("MAPException when parsing MAP-OPEN Pdu: " + e.getMessage()));
                try {
                    this.fireTCAbortProvider(tcBeginIndication.getDialog(), MAPProviderAbortReason.abnormalDialogue, null);
                }
                catch (MAPException e1) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e1);
                }
                return;
            }
        }
        if (perfSer == null) {
            for (MAPServiceBase ser : this.mapServices) {
                ServingCheckData chkRes = ser.isServingService(mapAppCtx);
                switch (chkRes.getResult()) {
                    case AC_Serving: {
                        perfSer = ser;
                        break;
                    }
                    case AC_VersionIncorrect: {
                        try {
                            this.fireTCAbortACNNotSupported(tcBeginIndication.getDialog(), null, chkRes.getAlternativeApplicationContext());
                            break;
                        }
                        catch (MAPException e1) {
                            this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e1);
                        }
                    }
                }
                if (perfSer == null) continue;
                break;
            }
        }
        if (perfSer == null) {
            StringBuffer s = new StringBuffer();
            s.append("Unsupported ApplicationContextName is received: ");
            for (long l : acn.getOid()) {
                s.append(l).append(", ");
            }
            this.loger.error((Object)s.toString());
            try {
                this.fireTCAbortACNNotSupported(tcBeginIndication.getDialog(), null, null);
            }
            catch (MAPException e1) {
                this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e1);
            }
            return;
        }
        if (!perfSer.isActivated()) {
            StringBuffer s = new StringBuffer();
            s.append("ApplicationContextName of not activated MAPService is received: ");
            for (long l : acn.getOid()) {
                s.append(l).append(", ");
            }
            try {
                this.fireTCAbortACNNotSupported(tcBeginIndication.getDialog(), null, null);
            }
            catch (MAPException e1) {
                this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e1);
            }
        }
        MAPDialogImpl mAPDialogImpl = mapDialogImpl = ((MAPServiceBaseImpl)perfSer).createNewDialogIncoming(mapAppCtx, tcBeginIndication.getDialog());
        synchronized (mAPDialogImpl) {
            this.addDialog(mapDialogImpl);
            mapDialogImpl.setState(MAPDialogState.InitialReceived);
            this.deliverDialogRequest(mapDialogImpl, destReference, origReference, extensionContainer);
            if (mapDialogImpl.getState() == MAPDialogState.Expunged) {
                return;
            }
            if (comps != null) {
                this.processComponents(mapDialogImpl, comps);
            }
            this.deliverDialogDelimiter(mapDialogImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTCContinue(TCContinueIndication tcContinueIndication) {
        Dialog tcapDialog = tcContinueIndication.getDialog();
        MAPDialogImpl mapDialogImpl = (MAPDialogImpl)this.getMAPDialog(tcapDialog.getDialogId());
        if (mapDialogImpl == null) {
            this.loger.error((Object)("MAP Dialog not found for Dialog Id " + tcapDialog.getDialogId()));
            try {
                this.fireTCAbortProvider(tcapDialog, MAPProviderAbortReason.abnormalDialogue, null);
            }
            catch (MAPException e) {
                this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
            }
            return;
        }
        MAPDialogImpl mAPDialogImpl = mapDialogImpl;
        synchronized (mAPDialogImpl) {
            if (mapDialogImpl.getState() == MAPDialogState.InitialSent) {
                ApplicationContextName acn = tcContinueIndication.getApplicationContextName();
                if (acn == null) {
                    if (mapDialogImpl.getApplicationContext().getApplicationContextVersion() != MAPApplicationContextVersion.version1) {
                        this.loger.error((Object)String.format("Received first TC-CONTINUE for MAPDialog=%s. But no application-context-name included", mapDialogImpl));
                        try {
                            this.fireTCAbortProvider(tcapDialog, MAPProviderAbortReason.abnormalDialogue, null);
                        }
                        catch (MAPException e) {
                            this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                        }
                        mapDialogImpl.setNormalDialogShutDown();
                        this.deliverDialogProviderAbort(mapDialogImpl, MAPAbortProviderReason.AbnormalMAPDialogue, MAPAbortSource.MAPProblem, null);
                        mapDialogImpl.setState(MAPDialogState.Expunged);
                        return;
                    }
                } else {
                    MAPApplicationContext mapAcn = MAPApplicationContext.getInstance((long[])acn.getOid());
                    if (mapAcn == null || !mapAcn.equals((Object)mapDialogImpl.getApplicationContext())) {
                        this.loger.error((Object)String.format("Received first TC-CONTINUE. MAPDialog=%s. But MAPApplicationContext=%s", mapDialogImpl, mapAcn));
                        try {
                            this.fireTCAbortProvider(tcapDialog, MAPProviderAbortReason.abnormalDialogue, null);
                        }
                        catch (MAPException e) {
                            this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                        }
                        mapDialogImpl.setNormalDialogShutDown();
                        this.deliverDialogProviderAbort(mapDialogImpl, MAPAbortProviderReason.AbnormalMAPDialogue, MAPAbortSource.MAPProblem, null);
                        mapDialogImpl.setState(MAPDialogState.Expunged);
                        return;
                    }
                }
                MAPExtensionContainer extensionContainer = null;
                UserInformation userInfo = tcContinueIndication.getUserInformation();
                if (userInfo != null) {
                    long[] oid;
                    MAPDialogueAS mapDialAs;
                    MAPAcceptInfoImpl mapAcceptInfoImpl = new MAPAcceptInfoImpl();
                    if (userInfo.isOid() && (mapDialAs = MAPDialogueAS.getInstance((long[])(oid = userInfo.getOidValue()))) != null && userInfo.isAsn()) {
                        try {
                            byte[] asnData = userInfo.getEncodeType();
                            AsnInputStream ais = new AsnInputStream(asnData);
                            int tag = ais.readTag();
                            if (tag == 1) {
                                mapAcceptInfoImpl.decodeAll(ais);
                                extensionContainer = mapAcceptInfoImpl.getExtensionContainer();
                            }
                        }
                        catch (AsnException e) {
                            e.printStackTrace();
                            this.loger.error((Object)("AsnException when parsing MAP-ACCEPT Pdu: " + e.getMessage()), (Throwable)e);
                            return;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            this.loger.error((Object)("IOException when parsing MAP-ACCEPT Pdu: " + e.getMessage()), (Throwable)e);
                        }
                        catch (MAPParsingComponentException e) {
                            e.printStackTrace();
                            this.loger.error((Object)("MAPException when parsing MAP-ACCEPT Pdu: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                mapDialogImpl.setState(MAPDialogState.Active);
                this.deliverDialogAccept(mapDialogImpl, extensionContainer);
                if (mapDialogImpl.getState() == MAPDialogState.Expunged) {
                    return;
                }
            }
            if (mapDialogImpl.getState() == MAPDialogState.InitialSent || mapDialogImpl.getState() == MAPDialogState.Active) {
                Component[] comps = tcContinueIndication.getComponents();
                if (comps != null) {
                    this.processComponents(mapDialogImpl, comps);
                }
            } else {
                this.loger.error((Object)String.format("Received TC-CONTINUE. MAPDialog=%s. But state is neither InitialSent or Active", mapDialogImpl));
            }
            this.deliverDialogDelimiter(mapDialogImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTCEnd(TCEndIndication tcEndIndication) {
        Dialog tcapDialog = tcEndIndication.getDialog();
        MAPDialogImpl mapDialogImpl = (MAPDialogImpl)this.getMAPDialog(tcapDialog.getDialogId());
        if (mapDialogImpl == null) {
            this.loger.error((Object)("MAP Dialog not found for Dialog Id " + tcapDialog.getDialogId()));
            return;
        }
        MAPDialogImpl mAPDialogImpl = mapDialogImpl;
        synchronized (mAPDialogImpl) {
            Component[] comps;
            if (mapDialogImpl.getState() == MAPDialogState.InitialSent) {
                long[] oid;
                MAPDialogueAS mapDialAs;
                ApplicationContextName acn = tcEndIndication.getApplicationContextName();
                if (acn == null) {
                    if (mapDialogImpl.getApplicationContext().getApplicationContextVersion() != MAPApplicationContextVersion.version1) {
                        boolean onlyErrorReject = false;
                        for (Component c : tcEndIndication.getComponents()) {
                            if (c.getType() == ComponentType.ReturnError || c.getType() == ComponentType.Reject) continue;
                            onlyErrorReject = true;
                            break;
                        }
                        if (onlyErrorReject) {
                            this.loger.error((Object)String.format("Received first TC-END for MAPDialog=%s. But no application-context-name included", mapDialogImpl));
                            mapDialogImpl.setNormalDialogShutDown();
                            this.deliverDialogProviderAbort(mapDialogImpl, MAPAbortProviderReason.AbnormalMAPDialogue, MAPAbortSource.MAPProblem, null);
                            mapDialogImpl.setState(MAPDialogState.Expunged);
                            return;
                        }
                    }
                } else {
                    MAPApplicationContext mapAcn = MAPApplicationContext.getInstance((long[])acn.getOid());
                    if (mapAcn == null || !mapAcn.equals((Object)mapDialogImpl.getApplicationContext())) {
                        this.loger.error((Object)String.format("Received first TC-END. MAPDialog=%s. But MAPApplicationContext=%s", mapDialogImpl, mapAcn));
                        mapDialogImpl.setNormalDialogShutDown();
                        this.deliverDialogProviderAbort(mapDialogImpl, MAPAbortProviderReason.AbnormalMAPDialogue, MAPAbortSource.MAPProblem, null);
                        mapDialogImpl.setState(MAPDialogState.Expunged);
                        return;
                    }
                }
                mapDialogImpl.setState(MAPDialogState.Active);
                MAPExtensionContainer extensionContainer = null;
                UserInformation userInfo = tcEndIndication.getUserInformation();
                if (userInfo != null && userInfo.isOid() && (mapDialAs = MAPDialogueAS.getInstance((long[])(oid = userInfo.getOidValue()))) != null && userInfo.isAsn()) {
                    try {
                        byte[] asnData = userInfo.getEncodeType();
                        AsnInputStream ais = new AsnInputStream(asnData);
                        int tag = ais.readTag();
                        if (tag == 1) {
                            MAPAcceptInfoImpl mapAcceptInfoImpl = new MAPAcceptInfoImpl();
                            mapAcceptInfoImpl.decodeAll(ais);
                            extensionContainer = mapAcceptInfoImpl.getExtensionContainer();
                        }
                        if (tag == 2) {
                            MAPCloseInfoImpl mapCloseInfoImpl = new MAPCloseInfoImpl();
                            mapCloseInfoImpl.decodeAll(ais);
                            extensionContainer = mapCloseInfoImpl.getExtensionContainer();
                        }
                    }
                    catch (AsnException e) {
                        e.printStackTrace();
                        this.loger.error((Object)("AsnException when parsing MAP-ACCEPT/MAP-CLOSE Pdu: " + e.getMessage()), (Throwable)e);
                        return;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.loger.error((Object)("IOException when parsing MAP-ACCEPT/MAP-CLOSE Pdu: " + e.getMessage()), (Throwable)e);
                    }
                    catch (MAPParsingComponentException e) {
                        e.printStackTrace();
                        this.loger.error((Object)("MAPException when parsing MAP-ACCEPT/MAP-CLOSE Pdu: " + e.getMessage()), (Throwable)e);
                    }
                }
                this.deliverDialogAccept(mapDialogImpl, extensionContainer);
                if (mapDialogImpl.getState() == MAPDialogState.Expunged) {
                    return;
                }
            }
            if ((comps = tcEndIndication.getComponents()) != null) {
                this.processComponents(mapDialogImpl, comps);
            }
            mapDialogImpl.setNormalDialogShutDown();
            this.deliverDialogClose(mapDialogImpl);
            mapDialogImpl.setState(MAPDialogState.Expunged);
        }
    }

    public void onTCUni(TCUniIndication arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInvokeTimeout(Invoke invoke) {
        MAPDialogImpl mapDialogImpl = (MAPDialogImpl)this.getMAPDialog(((InvokeImpl)invoke).getDialog().getDialogId());
        if (mapDialogImpl != null) {
            MAPDialogImpl mAPDialogImpl = mapDialogImpl;
            synchronized (mAPDialogImpl) {
                if (mapDialogImpl.getState() != MAPDialogState.Expunged && !mapDialogImpl.getNormalDialogShutDown().booleanValue()) {
                    MAPServiceBaseImpl perfSer = (MAPServiceBaseImpl)mapDialogImpl.getService();
                    perfSer.deliverInvokeTimeout(mapDialogImpl, invoke);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDialogTimeout(Dialog tcapDialog) {
        MAPDialogImpl mapDialogImpl = (MAPDialogImpl)this.getMAPDialog(tcapDialog.getDialogId());
        if (mapDialogImpl != null) {
            MAPDialogImpl mAPDialogImpl = mapDialogImpl;
            synchronized (mAPDialogImpl) {
                if (mapDialogImpl.getState() != MAPDialogState.Expunged && !mapDialogImpl.getNormalDialogShutDown().booleanValue()) {
                    this.deliverDialogTimeout(mapDialogImpl);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDialogReleased(Dialog tcapDialog) {
        MAPDialogImpl mapDialogImpl = (MAPDialogImpl)this.getMAPDialog(tcapDialog.getDialogId());
        if (mapDialogImpl != null) {
            MAPDialogImpl mAPDialogImpl = mapDialogImpl;
            synchronized (mAPDialogImpl) {
                if (mapDialogImpl.getState() != MAPDialogState.Expunged && !mapDialogImpl.getNormalDialogShutDown().booleanValue()) {
                    mapDialogImpl.setNormalDialogShutDown();
                    this.deliverDialogProviderAbort(mapDialogImpl, MAPAbortProviderReason.ProviderMalfunction, MAPAbortSource.TCProblem, null);
                    mapDialogImpl.setState(MAPDialogState.Expunged);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTCPAbort(TCPAbortIndication tcPAbortIndication) {
        Dialog tcapDialog = tcPAbortIndication.getDialog();
        MAPDialogImpl mapDialogImpl = (MAPDialogImpl)this.getMAPDialog(tcapDialog.getDialogId());
        if (mapDialogImpl == null) {
            this.loger.error((Object)("MAP Dialog not found for Dialog Id " + tcapDialog.getDialogId()));
            return;
        }
        MAPDialogImpl mAPDialogImpl = mapDialogImpl;
        synchronized (mAPDialogImpl) {
            PAbortCauseType pAbortCause = tcPAbortIndication.getPAbortCause();
            MAPAbortProviderReason abortProviderReason = MAPAbortProviderReason.ProviderMalfunction;
            MAPAbortSource abortSource = MAPAbortSource.TCProblem;
            switch (pAbortCause) {
                case UnrecogniedMessageType: 
                case BadlyFormattedTxPortion: {
                    abortProviderReason = MAPAbortProviderReason.ProviderMalfunction;
                    break;
                }
                case UnrecognizedTxID: {
                    abortProviderReason = MAPAbortProviderReason.SupportingDialogueTransactionReleased;
                    break;
                }
                case IncorrectTxPortion: {
                    if (mapDialogImpl.getState() == MAPDialogState.InitialSent) {
                        abortProviderReason = MAPAbortProviderReason.VersionIncompatibility;
                        break;
                    }
                    abortProviderReason = MAPAbortProviderReason.ProviderMalfunction;
                    break;
                }
                case ResourceLimitation: {
                    abortProviderReason = MAPAbortProviderReason.ResourceLimitation;
                }
            }
            mapDialogImpl.setNormalDialogShutDown();
            if (abortProviderReason == MAPAbortProviderReason.VersionIncompatibility) {
                this.deliverDialogReject(mapDialogImpl, MAPRefuseReason.PotentialVersionIncompatibility, null, null, null);
            } else {
                this.deliverDialogProviderAbort(mapDialogImpl, abortProviderReason, abortSource, null);
            }
            mapDialogImpl.setState(MAPDialogState.Expunged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTCUserAbort(TCUserAbortIndication tcUserAbortIndication) {
        Dialog tcapDialog = tcUserAbortIndication.getDialog();
        MAPDialogImpl mapDialogImpl = (MAPDialogImpl)this.getMAPDialog(tcapDialog.getDialogId());
        if (mapDialogImpl == null) {
            this.loger.error((Object)("MAP Dialog not found for Dialog Id " + tcapDialog.getDialogId()));
            return;
        }
        MAPDialogImpl mAPDialogImpl = mapDialogImpl;
        synchronized (mAPDialogImpl) {
            ResultSourceDiagnostic resultSourceDiagnostic;
            UserInformation userInfo = tcUserAbortIndication.getUserInformation();
            ParsePduResult parsePduResult = ParsePduResult.NoUserInfo;
            MAPRefuseReason mapRefuseReason = MAPRefuseReason.NoReasonGiven;
            MAPUserAbortChoice mapUserAbortChoice = null;
            MAPProviderAbortReason mapProviderAbortReason = null;
            MAPAbortProviderReason abortProviderReason = MAPAbortProviderReason.AbnormalMAPDialogue;
            MAPExtensionContainer extensionContainer = null;
            if (userInfo != null) {
                if (!userInfo.isOid()) {
                    this.loger.error((Object)"When parsing TCUserAbortIndication indication: userInfo.isOid() check failed");
                    parsePduResult = ParsePduResult.BadUserInfo;
                } else {
                    long[] oid = userInfo.getOidValue();
                    MAPDialogueAS mapDialAs = MAPDialogueAS.getInstance((long[])oid);
                    if (mapDialAs == null) {
                        this.loger.error((Object)"When parsing TCUserAbortIndication indication: userInfo.getOidValue() must be userInfoMAPDialogueAS.MAP_DialogueAS");
                        parsePduResult = ParsePduResult.BadUserInfo;
                    } else if (!userInfo.isAsn()) {
                        this.loger.error((Object)"When parsing TCUserAbortIndication indication: userInfo.isAsn() check failed");
                        parsePduResult = ParsePduResult.BadUserInfo;
                    } else {
                        try {
                            byte[] asnData = userInfo.getEncodeType();
                            AsnInputStream ais = new AsnInputStream(asnData);
                            int tag = ais.readTag();
                            switch (tag) {
                                case 3: {
                                    MAPRefuseInfoImpl mapRefuseInfoImpl = new MAPRefuseInfoImpl();
                                    mapRefuseInfoImpl.decodeAll(ais);
                                    switch (mapRefuseInfoImpl.getReason()) {
                                        case invalidOriginatingReference: {
                                            mapRefuseReason = MAPRefuseReason.InvalidOriginatingReference;
                                            break;
                                        }
                                        case invalidDestinationReference: {
                                            mapRefuseReason = MAPRefuseReason.InvalidDestinationReference;
                                        }
                                    }
                                    extensionContainer = mapRefuseInfoImpl.getExtensionContainer();
                                    parsePduResult = ParsePduResult.MapRefuse;
                                    break;
                                }
                                case 4: {
                                    MAPUserAbortInfoImpl mapUserAbortInfoImpl = new MAPUserAbortInfoImpl();
                                    mapUserAbortInfoImpl.decodeAll(ais);
                                    mapUserAbortChoice = mapUserAbortInfoImpl.getMAPUserAbortChoice();
                                    extensionContainer = mapUserAbortInfoImpl.getExtensionContainer();
                                    parsePduResult = ParsePduResult.MapUserAbort;
                                    break;
                                }
                                case 5: {
                                    MAPProviderAbortInfoImpl mapProviderAbortInfoImpl = new MAPProviderAbortInfoImpl();
                                    mapProviderAbortInfoImpl.decodeAll(ais);
                                    mapProviderAbortReason = mapProviderAbortInfoImpl.getMAPProviderAbortReason();
                                    switch (mapProviderAbortReason) {
                                        case abnormalDialogue: {
                                            abortProviderReason = MAPAbortProviderReason.AbnormalMAPDialogue;
                                            break;
                                        }
                                        case invalidPDU: {
                                            abortProviderReason = MAPAbortProviderReason.InvalidPDU;
                                        }
                                    }
                                    extensionContainer = mapProviderAbortInfoImpl.getExtensionContainer();
                                    parsePduResult = ParsePduResult.MapProviderAbort;
                                    break;
                                }
                                default: {
                                    this.loger.error((Object)"When parsing TCUserAbortIndication indication: userInfogetEncodeType().Tag must be either MAP_REFUSE_INFO_TAG or MAP_USER_ABORT_INFO_TAG or MAP_PROVIDER_ABORT_INFO_TAG");
                                    parsePduResult = ParsePduResult.BadUserInfo;
                                    break;
                                }
                            }
                        }
                        catch (AsnException e) {
                            this.loger.error((Object)("When parsing TCUserAbortIndication indication: AsnException" + e.getMessage()), (Throwable)e);
                            e.printStackTrace();
                            parsePduResult = ParsePduResult.BadUserInfo;
                        }
                        catch (IOException e) {
                            this.loger.error((Object)("When parsing TCUserAbortIndication indication: IOException" + e.getMessage()), (Throwable)e);
                            e.printStackTrace();
                            parsePduResult = ParsePduResult.BadUserInfo;
                        }
                        catch (MAPParsingComponentException e) {
                            this.loger.error((Object)("When parsing TCUserAbortIndication indication: MAPParsingComponentException" + e.getMessage()), (Throwable)e);
                            e.printStackTrace();
                            parsePduResult = ParsePduResult.BadUserInfo;
                        }
                    }
                }
            }
            if (tcUserAbortIndication.IsAareApdu().booleanValue() && (resultSourceDiagnostic = tcUserAbortIndication.getResultSourceDiagnostic()) != null) {
                if (resultSourceDiagnostic.getDialogServiceUserType() == DialogServiceUserType.AcnNotSupported) {
                    if (mapDialogImpl.getState() == MAPDialogState.InitialSent) {
                        mapDialogImpl.setNormalDialogShutDown();
                        this.deliverDialogReject(mapDialogImpl, MAPRefuseReason.ApplicationContextNotSupported, null, tcUserAbortIndication.getApplicationContextName(), extensionContainer);
                        mapDialogImpl.setState(MAPDialogState.Expunged);
                        return;
                    }
                    parsePduResult = ParsePduResult.BadUserInfo;
                } else if (resultSourceDiagnostic.getDialogServiceProviderType() == DialogServiceProviderType.NoCommonDialogPortion) {
                    if (mapDialogImpl.getState() == MAPDialogState.InitialSent) {
                        mapDialogImpl.setNormalDialogShutDown();
                        this.deliverDialogReject(mapDialogImpl, MAPRefuseReason.PotentialVersionIncompatibility, null, null, null);
                        mapDialogImpl.setState(MAPDialogState.Expunged);
                        return;
                    }
                    parsePduResult = ParsePduResult.BadUserInfo;
                }
            }
            mapDialogImpl.setNormalDialogShutDown();
            switch (parsePduResult) {
                case NoUserInfo: {
                    if (mapDialogImpl.getState() == MAPDialogState.InitialSent) {
                        this.deliverDialogReject(mapDialogImpl, MAPRefuseReason.PotentialVersionIncompatibility, null, null, null);
                        break;
                    }
                    this.deliverDialogProviderAbort(mapDialogImpl, MAPAbortProviderReason.AbnormalMAPDialogue, MAPAbortSource.MAPProblem, null);
                    break;
                }
                case BadUserInfo: {
                    this.deliverDialogProviderAbort(mapDialogImpl, MAPAbortProviderReason.AbnormalMAPDialogue, MAPAbortSource.MAPProblem, null);
                    break;
                }
                case MapRefuse: {
                    if (mapDialogImpl.getState() == MAPDialogState.InitialSent) {
                        this.deliverDialogReject(mapDialogImpl, mapRefuseReason, null, null, extensionContainer);
                        break;
                    }
                    this.deliverDialogProviderAbort(mapDialogImpl, MAPAbortProviderReason.AbnormalMAPDialogue, MAPAbortSource.MAPProblem, null);
                    break;
                }
                case MapUserAbort: {
                    this.deliverDialogUserAbort(mapDialogImpl, mapUserAbortChoice, extensionContainer);
                    break;
                }
                case MapProviderAbort: {
                    this.deliverDialogProviderAbort(mapDialogImpl, abortProviderReason, MAPAbortSource.MAPProblem, extensionContainer);
                }
            }
            mapDialogImpl.setState(MAPDialogState.Expunged);
        }
    }

    private void processComponents(MAPDialogImpl mapDialogImpl, Component[] components) {
        MAPServiceBaseImpl perfSer = (MAPServiceBaseImpl)mapDialogImpl.getService();
        for (Component c : components) {
            try {
                Problem problem;
                Parameter parameter;
                OperationCode oc;
                ComponentType compType = c.getType();
                Long invokeId = c.getInvokeId();
                Long linkedId = 0L;
                switch (compType) {
                    case Invoke: {
                        Invoke comp = (Invoke)c;
                        oc = comp.getOperationCode();
                        parameter = comp.getParameter();
                        linkedId = comp.getLinkedId();
                        if (!mapDialogImpl.addIncomingInvokeId(invokeId)) {
                            this.deliverDialogNotice(mapDialogImpl, MAPNoticeProblemDiagnostic.AbnormalEventReceivedFromThePeer);
                            problem = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.Invoke);
                            problem.setInvokeProblemType(InvokeProblemType.DuplicateInvokeID);
                            mapDialogImpl.sendRejectComponent(null, problem);
                            return;
                        }
                        if (linkedId == null || mapDialogImpl.checkIncomingInvokeIdExists(linkedId).booleanValue()) break;
                        this.deliverDialogNotice(mapDialogImpl, MAPNoticeProblemDiagnostic.AbnormalEventReceivedFromThePeer);
                        problem = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.Invoke);
                        problem.setInvokeProblemType(InvokeProblemType.UnrechognizedLinkedID);
                        mapDialogImpl.sendRejectComponent(invokeId, problem);
                        return;
                    }
                    case ReturnResult: {
                        Invoke comp = (ReturnResult)c;
                        oc = comp.getOperationCode();
                        parameter = comp.getParameter();
                        break;
                    }
                    case ReturnResultLast: {
                        Invoke comp = (ReturnResultLast)c;
                        oc = comp.getOperationCode();
                        parameter = comp.getParameter();
                        break;
                    }
                    case ReturnError: {
                        Invoke comp = (ReturnError)c;
                        long errorCode = 0L;
                        if (comp.getErrorCode() != null && comp.getErrorCode().getErrorType() == ErrorCodeType.Local) {
                            errorCode = comp.getErrorCode().getLocalErrorCode();
                        }
                        if (errorCode < 1L || errorCode > 72L) {
                            perfSer.deliverProviderErrorComponent(mapDialogImpl, invokeId, MAPProviderError.InvalidResponseReceived);
                            Problem problem2 = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.ReturnError);
                            problem2.setReturnErrorProblemType(ReturnErrorProblemType.UnrecognizedError);
                            mapDialogImpl.sendRejectComponent(invokeId, problem2);
                            return;
                        }
                        MAPErrorMessage msgErr = this.mapErrorMessageFactory.createMessageFromErrorCode(Long.valueOf(errorCode));
                        try {
                            Parameter p = comp.getParameter();
                            if (p != null && p.getData() != null) {
                                byte[] data = p.getData();
                                AsnInputStream ais = new AsnInputStream(data, p.getTagClass(), p.isPrimitive(), p.getTag());
                                ((MAPErrorMessageImpl)msgErr).decodeData(ais, data.length);
                            }
                        }
                        catch (MAPParsingComponentException e) {
                            perfSer.deliverProviderErrorComponent(mapDialogImpl, invokeId, MAPProviderError.InvalidResponseReceived);
                            Problem problem3 = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.ReturnError);
                            problem3.setReturnErrorProblemType(ReturnErrorProblemType.MistypedParameter);
                            mapDialogImpl.sendRejectComponent(invokeId, problem3);
                            return;
                        }
                        perfSer.deliverErrorComponent(mapDialogImpl, comp.getInvokeId(), msgErr);
                        return;
                    }
                    case Reject: {
                        Invoke comp = (Reject)c;
                        perfSer.deliverRejectComponent(mapDialogImpl, comp.getInvokeId(), comp.getProblem());
                        return;
                    }
                    default: {
                        return;
                    }
                }
                try {
                    perfSer.processComponent(compType, oc, parameter, mapDialogImpl, invokeId, linkedId);
                }
                catch (MAPParsingComponentException e) {
                    this.loger.error((Object)("MAPParsingComponentException when parsing components: " + e.getReason().toString() + " - " + e.getMessage()), (Throwable)e);
                    switch (e.getReason()) {
                        case UnrecognizedOperation: {
                            if (compType == ComponentType.Invoke) {
                                this.deliverDialogNotice(mapDialogImpl, MAPNoticeProblemDiagnostic.AbnormalEventReceivedFromThePeer);
                                problem = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.Invoke);
                                problem.setInvokeProblemType(InvokeProblemType.UnrecognizedOperation);
                                mapDialogImpl.sendRejectComponent(invokeId, problem);
                                break;
                            }
                            perfSer.deliverProviderErrorComponent(mapDialogImpl, invokeId, MAPProviderError.InvalidResponseReceived);
                            problem = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.ReturnResult);
                            problem.setReturnResultProblemType(ReturnResultProblemType.MistypedParameter);
                            mapDialogImpl.sendRejectComponent(invokeId, problem);
                            break;
                        }
                        case MistypedParameter: {
                            if (compType == ComponentType.Invoke) {
                                this.deliverDialogNotice(mapDialogImpl, MAPNoticeProblemDiagnostic.AbnormalEventReceivedFromThePeer);
                                problem = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.Invoke);
                                problem.setInvokeProblemType(InvokeProblemType.MistypedParameter);
                                mapDialogImpl.sendRejectComponent(invokeId, problem);
                                break;
                            }
                            perfSer.deliverProviderErrorComponent(mapDialogImpl, invokeId, MAPProviderError.InvalidResponseReceived);
                            problem = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.ReturnResult);
                            problem.setReturnResultProblemType(ReturnResultProblemType.MistypedParameter);
                            mapDialogImpl.sendRejectComponent(invokeId, problem);
                            break;
                        }
                        case LinkedResponseUnexpected: {
                            if (compType != ComponentType.Invoke) break;
                            this.deliverDialogNotice(mapDialogImpl, MAPNoticeProblemDiagnostic.AbnormalEventReceivedFromThePeer);
                            problem = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.Invoke);
                            problem.setInvokeProblemType(InvokeProblemType.LinkedResponseUnexpected);
                            mapDialogImpl.sendRejectComponent(invokeId, problem);
                            break;
                        }
                        case UnexpectedLinkedOperation: {
                            if (compType != ComponentType.Invoke) break;
                            this.deliverDialogNotice(mapDialogImpl, MAPNoticeProblemDiagnostic.AbnormalEventReceivedFromThePeer);
                            problem = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.Invoke);
                            problem.setInvokeProblemType(InvokeProblemType.UnexpectedLinkedOperation);
                            mapDialogImpl.sendRejectComponent(invokeId, problem);
                        }
                    }
                }
            }
            catch (MAPException e) {
                this.loger.error((Object)("Error sending the RejectComponent: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void deliverDialogDelimiter(MAPDialog mapDialog) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogDelimiter(mapDialog);
        }
    }

    private void deliverDialogRequest(MAPDialog mapDialog, AddressString destReference, AddressString origReference, MAPExtensionContainer extensionContainer) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogRequest(mapDialog, destReference, origReference, extensionContainer);
        }
    }

    private void deliverDialogAccept(MAPDialog mapDialog, MAPExtensionContainer extensionContainer) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogAccept(mapDialog, extensionContainer);
        }
    }

    private void deliverDialogReject(MAPDialog mapDialog, MAPRefuseReason refuseReason, MAPProviderError providerError, ApplicationContextName alternativeApplicationContext, MAPExtensionContainer extensionContainer) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogReject(mapDialog, refuseReason, providerError, alternativeApplicationContext, extensionContainer);
        }
    }

    private void deliverDialogClose(MAPDialog mapDialog) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogClose(mapDialog);
        }
    }

    private void deliverDialogProviderAbort(MAPDialog mapDialog, MAPAbortProviderReason abortProviderReason, MAPAbortSource abortSource, MAPExtensionContainer extensionContainer) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogProviderAbort(mapDialog, abortProviderReason, abortSource, extensionContainer);
        }
    }

    private void deliverDialogUserAbort(MAPDialog mapDialog, MAPUserAbortChoice userReason, MAPExtensionContainer extensionContainer) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogUserAbort(mapDialog, userReason, extensionContainer);
        }
    }

    protected void deliverDialogNotice(MAPDialog mapDialog, MAPNoticeProblemDiagnostic noticeProblemDiagnostic) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogNotice(mapDialog, noticeProblemDiagnostic);
        }
    }

    protected void deliverDialogResease(MAPDialog mapDialog) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogResease(mapDialog);
        }
    }

    protected void deliverDialogTimeout(MAPDialog mapDialog) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogTimeout(mapDialog);
        }
    }

    protected void fireTCBegin(Dialog tcapDialog, ApplicationContextName acn, AddressString destReference, AddressString origReference, MAPExtensionContainer mapExtensionContainer) throws MAPException {
        TCBeginRequest tcBeginReq = this.encodeTCBegin(tcapDialog, acn, destReference, origReference, mapExtensionContainer);
        try {
            tcapDialog.send(tcBeginReq);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    protected TCBeginRequest encodeTCBegin(Dialog tcapDialog, ApplicationContextName acn, AddressString destReference, AddressString origReference, MAPExtensionContainer mapExtensionContainer) throws MAPException {
        TCBeginRequest tcBeginReq = this.getTCAPProvider().getDialogPrimitiveFactory().createBegin(tcapDialog);
        if (MAPApplicationContext.getProtocolVersion((long[])acn.getOid()) > 1) {
            tcBeginReq.setApplicationContextName(acn);
        }
        if ((destReference != null || origReference != null || mapExtensionContainer != null) && MAPApplicationContext.getProtocolVersion((long[])acn.getOid()) > 1) {
            MAPOpenInfoImpl mapOpn = new MAPOpenInfoImpl();
            mapOpn.setDestReference(destReference);
            mapOpn.setOrigReference(origReference);
            mapOpn.setExtensionContainer(mapExtensionContainer);
            AsnOutputStream localasnOs = new AsnOutputStream();
            mapOpn.encodeAll(localasnOs);
            UserInformation userInformation = TcapFactory.createUserInformation();
            userInformation.setOid(true);
            userInformation.setOidValue(MAPDialogueAS.MAP_DialogueAS.getOID());
            userInformation.setAsn(true);
            userInformation.setEncodeType(localasnOs.toByteArray());
            tcBeginReq.setUserInformation(userInformation);
        }
        return tcBeginReq;
    }

    protected void fireTCContinue(Dialog tcapDialog, Boolean sendMapAcceptInfo, ApplicationContextName acn, MAPExtensionContainer mapExtensionContainer) throws MAPException {
        TCContinueRequest tcContinueReq = this.encodeTCContinue(tcapDialog, sendMapAcceptInfo, acn, mapExtensionContainer);
        try {
            tcapDialog.send(tcContinueReq);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    protected TCContinueRequest encodeTCContinue(Dialog tcapDialog, Boolean sendMapAcceptInfo, ApplicationContextName acn, MAPExtensionContainer mapExtensionContainer) throws MAPException {
        TCContinueRequest tcContinueReq = this.getTCAPProvider().getDialogPrimitiveFactory().createContinue(tcapDialog);
        if (acn != null && MAPApplicationContext.getProtocolVersion((long[])acn.getOid()) > 1) {
            tcContinueReq.setApplicationContextName(acn);
        }
        if (sendMapAcceptInfo.booleanValue() && mapExtensionContainer != null && MAPApplicationContext.getProtocolVersion((long[])acn.getOid()) > 1) {
            MAPAcceptInfoImpl mapAccept = new MAPAcceptInfoImpl();
            mapAccept.setExtensionContainer(mapExtensionContainer);
            AsnOutputStream localasnOs = new AsnOutputStream();
            mapAccept.encodeAll(localasnOs);
            UserInformation userInformation = TcapFactory.createUserInformation();
            userInformation.setOid(true);
            userInformation.setOidValue(MAPDialogueAS.MAP_DialogueAS.getOID());
            userInformation.setAsn(true);
            userInformation.setEncodeType(localasnOs.toByteArray());
            tcContinueReq.setUserInformation(userInformation);
        }
        return tcContinueReq;
    }

    protected void fireTCEnd(Dialog tcapDialog, Boolean sendMapCloseInfo, boolean prearrangedEnd, ApplicationContextName acn, MAPExtensionContainer mapExtensionContainer) throws MAPException {
        TCEndRequest endRequest = this.encodeTCEnd(tcapDialog, sendMapCloseInfo, prearrangedEnd, acn, mapExtensionContainer);
        try {
            tcapDialog.send(endRequest);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    protected TCEndRequest encodeTCEnd(Dialog tcapDialog, Boolean sendMapCloseInfo, boolean prearrangedEnd, ApplicationContextName acn, MAPExtensionContainer mapExtensionContainer) throws MAPException {
        TCEndRequest endRequest = this.getTCAPProvider().getDialogPrimitiveFactory().createEnd(tcapDialog);
        if (!prearrangedEnd) {
            endRequest.setTermination(TerminationType.Basic);
        } else {
            endRequest.setTermination(TerminationType.PreArranged);
        }
        if (acn != null && MAPApplicationContext.getProtocolVersion((long[])acn.getOid()) > 1) {
            endRequest.setApplicationContextName(acn);
        }
        if (sendMapCloseInfo.booleanValue() && mapExtensionContainer != null && MAPApplicationContext.getProtocolVersion((long[])acn.getOid()) > 1) {
            MAPAcceptInfoImpl mapAccept = new MAPAcceptInfoImpl();
            mapAccept.setExtensionContainer(mapExtensionContainer);
            AsnOutputStream localasnOs = new AsnOutputStream();
            mapAccept.encodeAll(localasnOs);
            UserInformation userInformation = TcapFactory.createUserInformation();
            userInformation.setOid(true);
            userInformation.setOidValue(MAPDialogueAS.MAP_DialogueAS.getOID());
            userInformation.setAsn(true);
            userInformation.setEncodeType(localasnOs.toByteArray());
            endRequest.setUserInformation(userInformation);
        }
        return endRequest;
    }

    private void fireTCAbortACNNotSupported(Dialog tcapDialog, MAPExtensionContainer mapExtensionContainer, ApplicationContextName alternativeApplicationContext) throws MAPException {
        if (tcapDialog.getApplicationContextName() == null) {
            this.fireTCAbortV1(tcapDialog);
        }
        TCUserAbortRequest tcUserAbort = this.getTCAPProvider().getDialogPrimitiveFactory().createUAbort(tcapDialog);
        MAPRefuseInfoImpl mapRefuseInfoImpl = new MAPRefuseInfoImpl();
        mapRefuseInfoImpl.setReason(Reason.noReasonGiven);
        AsnOutputStream localasnOs = new AsnOutputStream();
        mapRefuseInfoImpl.encodeAll(localasnOs);
        UserInformation userInformation = TcapFactory.createUserInformation();
        userInformation.setOid(true);
        userInformation.setOidValue(MAPDialogueAS.MAP_DialogueAS.getOID());
        userInformation.setAsn(true);
        userInformation.setEncodeType(localasnOs.toByteArray());
        if (alternativeApplicationContext != null) {
            tcUserAbort.setApplicationContextName(alternativeApplicationContext);
        } else {
            tcUserAbort.setApplicationContextName(tcapDialog.getApplicationContextName());
        }
        tcUserAbort.setDialogServiceUserType(DialogServiceUserType.AcnNotSupported);
        tcUserAbort.setUserInformation(userInformation);
        try {
            tcapDialog.send(tcUserAbort);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    protected void fireTCAbortRefused(Dialog tcapDialog, Reason reason, MAPExtensionContainer mapExtensionContainer) throws MAPException {
        if (tcapDialog.getApplicationContextName() == null) {
            this.fireTCAbortV1(tcapDialog);
        }
        TCUserAbortRequest tcUserAbort = this.getTCAPProvider().getDialogPrimitiveFactory().createUAbort(tcapDialog);
        MAPRefuseInfoImpl mapRefuseInfoImpl = new MAPRefuseInfoImpl();
        mapRefuseInfoImpl.setReason(reason);
        mapRefuseInfoImpl.setExtensionContainer(mapExtensionContainer);
        AsnOutputStream localasnOs = new AsnOutputStream();
        mapRefuseInfoImpl.encodeAll(localasnOs);
        UserInformation userInformation = TcapFactory.createUserInformation();
        userInformation.setOid(true);
        userInformation.setOidValue(MAPDialogueAS.MAP_DialogueAS.getOID());
        userInformation.setAsn(true);
        userInformation.setEncodeType(localasnOs.toByteArray());
        tcUserAbort.setApplicationContextName(tcapDialog.getApplicationContextName());
        tcUserAbort.setDialogServiceUserType(DialogServiceUserType.NoReasonGive);
        tcUserAbort.setUserInformation(userInformation);
        try {
            tcapDialog.send(tcUserAbort);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    protected void fireTCAbortUser(Dialog tcapDialog, MAPUserAbortChoice mapUserAbortChoice, MAPExtensionContainer mapExtensionContainer) throws MAPException {
        if (tcapDialog.getApplicationContextName() == null) {
            this.fireTCAbortV1(tcapDialog);
        }
        TCUserAbortRequest tcUserAbort = this.getTCAPProvider().getDialogPrimitiveFactory().createUAbort(tcapDialog);
        MAPUserAbortInfoImpl mapUserAbortInfoImpl = new MAPUserAbortInfoImpl();
        mapUserAbortInfoImpl.setMAPUserAbortChoice(mapUserAbortChoice);
        mapUserAbortInfoImpl.setExtensionContainer(mapExtensionContainer);
        AsnOutputStream localasnOs = new AsnOutputStream();
        mapUserAbortInfoImpl.encodeAll(localasnOs);
        UserInformation userInformation = TcapFactory.createUserInformation();
        userInformation.setOid(true);
        userInformation.setOidValue(MAPDialogueAS.MAP_DialogueAS.getOID());
        userInformation.setAsn(true);
        userInformation.setEncodeType(localasnOs.toByteArray());
        tcUserAbort.setUserInformation(userInformation);
        try {
            tcapDialog.send(tcUserAbort);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    protected void fireTCAbortProvider(Dialog tcapDialog, MAPProviderAbortReason mapProviderAbortReason, MAPExtensionContainer mapExtensionContainer) throws MAPException {
        if (tcapDialog.getApplicationContextName() == null) {
            this.fireTCAbortV1(tcapDialog);
        }
        TCUserAbortRequest tcUserAbort = this.getTCAPProvider().getDialogPrimitiveFactory().createUAbort(tcapDialog);
        MAPProviderAbortInfoImpl mapProviderAbortInfo = new MAPProviderAbortInfoImpl();
        mapProviderAbortInfo.setMAPProviderAbortReason(mapProviderAbortReason);
        mapProviderAbortInfo.setExtensionContainer(mapExtensionContainer);
        AsnOutputStream localasnOs = new AsnOutputStream();
        mapProviderAbortInfo.encodeAll(localasnOs);
        UserInformation userInformation = TcapFactory.createUserInformation();
        userInformation.setOid(true);
        userInformation.setOidValue(MAPDialogueAS.MAP_DialogueAS.getOID());
        userInformation.setAsn(true);
        userInformation.setEncodeType(localasnOs.toByteArray());
        tcUserAbort.setUserInformation(userInformation);
        try {
            tcapDialog.send(tcUserAbort);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    protected void fireTCAbortV1(Dialog tcapDialog) throws MAPException {
        TCUserAbortRequest tcUserAbort = this.getTCAPProvider().getDialogPrimitiveFactory().createUAbort(tcapDialog);
        try {
            tcapDialog.send(tcUserAbort);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParsePduResult {
        NoUserInfo,
        BadUserInfo,
        MapRefuse,
        MapUserAbort,
        MapProviderAbort;

    }
}

