/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.primitives;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.AlertingCategory;
import org.mobicents.protocols.ss7.map.api.primitives.AlertingLevel;
import org.mobicents.protocols.ss7.map.api.primitives.AlertingPattern;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class AlertingPatternImpl
implements AlertingPattern,
MAPAsnPrimitive {
    private AlertingLevel alertingLevel;
    private AlertingCategory alertingCategory;

    public AlertingPatternImpl() {
    }

    public AlertingPatternImpl(AlertingLevel alertingLevel) {
        this.alertingLevel = alertingLevel;
    }

    public AlertingPatternImpl(AlertingCategory alertingCategory) {
        this.alertingCategory = alertingCategory;
    }

    public int getTag() throws MAPException {
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AlertingPattern: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding AlertingPattern: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AlertingPattern: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding AlertingPattern: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        if (length != 1) {
            throw new MAPParsingComponentException("Error decoding AlertingPattern: the AlertingPattern field must contain 1 octets. Contains: " + length, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] rawdata = ansIS.readOctetStringData(length);
        byte data = rawdata[0];
        switch (data) {
            case 0: {
                this.alertingLevel = AlertingLevel.Level0;
                break;
            }
            case 1: {
                this.alertingLevel = AlertingLevel.Level1;
                break;
            }
            case 2: {
                this.alertingLevel = AlertingLevel.Level2;
                break;
            }
            case 4: {
                this.alertingCategory = AlertingCategory.Category1;
                break;
            }
            case 5: {
                this.alertingCategory = AlertingCategory.Category2;
                break;
            }
            case 6: {
                this.alertingCategory = AlertingCategory.Category3;
                break;
            }
            case 7: {
                this.alertingCategory = AlertingCategory.Category4;
                break;
            }
            case 8: {
                this.alertingCategory = AlertingCategory.Category5;
                break;
            }
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 4);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding AlertingPattern: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.alertingLevel == null && this.alertingCategory == null) {
            throw new MAPException("Error when encoding AlertingPattern: alertingLevel and alertingCategory is empty");
        }
        byte[] rawData = null;
        rawData = this.alertingLevel != null ? new byte[]{this.alertingLevel.getLevel()} : new byte[]{this.alertingCategory.getCategory()};
        asnOs.writeOctetStringData(rawData);
    }

    public AlertingLevel getAlertingLevel() {
        return this.alertingLevel;
    }

    public AlertingCategory getAlertingCategory() {
        return this.alertingCategory;
    }
}

