/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.primitives;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.primitives.TbcdString;

public class IMSIImpl
extends TbcdString
implements IMSI {
    private Long MCC;
    private Long MNC;
    private String MSIN;

    public IMSIImpl() {
    }

    public IMSIImpl(Long MCC, Long MNC, String MSIN) {
        this.MCC = MCC;
        this.MNC = MNC;
        this.MSIN = MSIN;
    }

    public Long getMCC() {
        return this.MCC;
    }

    public Long getMNC() {
        return this.MNC;
    }

    public String getMSIN() {
        return this.MSIN;
    }

    public int getTag() throws MAPException {
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding IMSI: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding IMSI: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException {
        if (length < 3 || length > 8) {
            throw new MAPParsingComponentException("Error decoding IMSI: the IMSI field must contain from 3 to 8 octets. Contains: " + length, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        try {
            String res = this.decodeString(ansIS, length);
            String sMcc = res.substring(0, 3);
            String sMnc = res.substring(3, 5);
            this.MSIN = res.substring(5);
            this.MCC = Integer.parseInt(sMcc);
            this.MNC = Integer.parseInt(sMnc);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding IMSI: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 4);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding IMSI: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.MCC == null || this.MNC == null || this.MSIN == null) {
            throw new MAPException("Error while encoding the IMSI: MMC, MNC or MSIN is not defined");
        }
        if (this.MCC < 0L || this.MCC > 999L) {
            throw new MAPException("Error while encoding the IMSI: Bad MCC value");
        }
        if (this.MNC < 0L || this.MNC > 99L) {
            throw new MAPException("Error while encoding the IMSI: Bad MNC value");
        }
        if (this.MSIN.length() < 1 || this.MSIN.length() > 11) {
            throw new MAPException("Error while encoding the IMSI: Bad MSIN value");
        }
        StringBuilder sb = new StringBuilder();
        if (this.MCC < 100L) {
            sb.append("0");
        }
        if (this.MCC < 10L) {
            sb.append("0");
        }
        sb.append(this.MCC);
        if (this.MNC < 10L) {
            sb.append("0");
        }
        sb.append(this.MNC);
        sb.append(this.MSIN);
        this.encodeString(asnOs, sb.toString());
    }

    public String toString() {
        return "IMSI [MCC=" + this.MCC + ", MNC=" + this.MNC + ", MSIN=" + this.MSIN + "]";
    }
}

