/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.primitives;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.primitives.MAPPrivateExtension;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.primitives.MAPPrivateExtensionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MAPExtensionContainerImpl
implements MAPExtensionContainer,
MAPAsnPrimitive {
    protected static final int PRIVATEEXTENSIONLIST_REF_TAG = 0;
    protected static final int PSCEXTENSIONS_REF_TAG = 1;
    private ArrayList<MAPPrivateExtension> privateExtensionList;
    private byte[] pcsExtensions;

    public MAPExtensionContainerImpl() {
    }

    public MAPExtensionContainerImpl(ArrayList<MAPPrivateExtension> privateExtensionList, byte[] pcsExtensions) {
        this.privateExtensionList = privateExtensionList;
        this.pcsExtensions = pcsExtensions;
    }

    public ArrayList<MAPPrivateExtension> getPrivateExtensionList() {
        return this.privateExtensionList;
    }

    public void setPrivateExtensionList(ArrayList<MAPPrivateExtension> privateExtensionList) {
        this.privateExtensionList = privateExtensionList;
    }

    public byte[] getPcsExtensions() {
        return this.pcsExtensions;
    }

    public void setPcsExtensions(byte[] pcsExtensions) {
        this.pcsExtensions = pcsExtensions;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            AsnInputStream ais = ansIS.readSequenceStream();
            this._decode(ais);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ExtensionContainer: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ExtensionContainer: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            AsnInputStream ais = ansIS.readSequenceStreamData(length);
            this._decode(ais);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ExtensionContainer: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ExtensionContainer: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS) throws MAPParsingComponentException, IOException, AsnException {
        this.privateExtensionList = null;
        this.pcsExtensions = null;
        while (ansIS.available() != 0) {
            int tag = ansIS.readTag();
            if (tag == 0 && ansIS.getTagClass() == 2) {
                if (ansIS.isTagPrimitive()) {
                    throw new MAPParsingComponentException("Error while ExtensionContainer decoding: privateExtensionList is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                if (this.privateExtensionList != null) {
                    throw new MAPParsingComponentException("Error while ExtensionContainer decoding: More than one PrivateExtensionList has found", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                AsnInputStream localAis2 = ansIS.readSequenceStream();
                this.privateExtensionList = new ArrayList();
                while (localAis2.available() > 0) {
                    tag = localAis2.readTag();
                    if (tag != 16 || localAis2.getTagClass() != 0 || localAis2.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while ExtensionContainer decoding: Bad tag, tagClass or primitiveFactor of PrivateExtension", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    if (this.privateExtensionList.size() >= 10) {
                        throw new MAPParsingComponentException("More then 10 PrivateExtension found when PrivateExtensionList decoding", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    MAPPrivateExtensionImpl privateExtension = new MAPPrivateExtensionImpl();
                    privateExtension.decodeAll(localAis2);
                    this.privateExtensionList.add(privateExtension);
                }
                continue;
            }
            if (tag != 1 || ansIS.getTagClass() != 2) continue;
            if (ansIS.isTagPrimitive()) {
                throw new MAPParsingComponentException("Error while PCS-Extensions decoding: PCS-Extensions is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
            }
            if (this.pcsExtensions != null) {
                throw new MAPParsingComponentException("Error while PCS-Extensions decoding: More than one PCS-Extensions has found", MAPParsingComponentExceptionReason.MistypedParameter);
            }
            this.pcsExtensions = ansIS.readSequence();
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ExtensionContainer: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.privateExtensionList == null && this.pcsExtensions == null) {
            throw new MAPException("Error when encoding ExtensionContainer: Both PrivateExtensionList and PcsExtensions are empty when ExtensionContainer encoding");
        }
        if (this.privateExtensionList != null && (this.privateExtensionList.size() == 0 || this.privateExtensionList.size() > 10)) {
            throw new MAPException("Error when encoding ExtensionContainer: PrivateExtensionList must contains from 1 to 10 elements when ExtensionContainer encoding");
        }
        try {
            int pos2;
            if (this.privateExtensionList != null) {
                asnOs.writeTag(2, false, 0);
                pos2 = asnOs.StartContentDefiniteLength();
                for (MAPPrivateExtension pe : this.privateExtensionList) {
                    ((MAPPrivateExtensionImpl)pe).encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos2);
            }
            if (this.pcsExtensions != null) {
                asnOs.writeTag(2, false, 1);
                pos2 = asnOs.StartContentDefiniteLength();
                asnOs.write(this.pcsExtensions);
                asnOs.FinalizeContent(pos2);
            }
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ExtensionContainer: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExtensionContainer [");
        if (this.privateExtensionList != null && this.privateExtensionList.size() > 0) {
            for (MAPPrivateExtension pe : this.privateExtensionList) {
                sb.append("\n");
                sb.append(pe.toString());
            }
        }
        if (this.pcsExtensions != null) {
            sb.append("\nPcsExtensions=");
            sb.append(this.ArrayToString(this.pcsExtensions));
        }
        sb.append("]");
        return sb.toString();
    }

    private String ArrayToString(byte[] array) {
        StringBuilder sb = new StringBuilder();
        boolean i1 = false;
        for (byte b : array) {
            if (!i1) {
                i1 = true;
            } else {
                sb.append(", ");
            }
            sb.append(b);
        }
        return sb.toString();
    }
}

