/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.primitives;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPPrivateExtension;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class MAPPrivateExtensionImpl
implements MAPPrivateExtension,
MAPAsnPrimitive {
    private long[] oId;
    private byte[] data;

    public MAPPrivateExtensionImpl() {
    }

    public MAPPrivateExtensionImpl(long[] oId, byte[] data) {
        this.oId = oId;
        this.data = data;
    }

    public long[] getOId() {
        return this.oId;
    }

    public void setOId(long[] oId) {
        this.oId = oId;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            AsnInputStream ais = ansIS.readSequenceStream();
            this._decode(ais);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding PrivateExtension: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding PrivateExtension: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            AsnInputStream ais = ansIS.readSequenceStreamData(length);
            this._decode(ais);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding PrivateExtension: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding PrivateExtension: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS) throws MAPParsingComponentException, IOException, AsnException {
        int tag = ansIS.readTag();
        if (tag != 6 || ansIS.getTagClass() != 0 || !ansIS.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error decoding PrivateExtension: bad tag, tagClass or primitiveFactor of ExtentionId", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.oId = ansIS.readObjectIdentifier();
        if (ansIS.available() > 0) {
            this.data = new byte[ansIS.available()];
            ansIS.read(this.data);
        } else {
            this.data = null;
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding PrivateExtension: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.oId == null || this.oId.length < 2) {
            throw new MAPException("Error when encoding PrivateExtension: OId value must not be empty when coding PrivateExtension");
        }
        try {
            asnOs.writeObjectIdentifier(this.oId);
            if (this.data != null) {
                asnOs.write(this.data);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding PrivateExtension: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding PrivateExtension: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PrivateExtension [");
        if (this.oId != null || this.oId.length > 0) {
            sb.append("Oid=");
            sb.append(this.ArrayToString(this.oId));
        }
        if (this.data != null) {
            sb.append(", data=");
            sb.append(this.ArrayToString(this.data));
        }
        sb.append("]");
        return sb.toString();
    }

    private String ArrayToString(byte[] array) {
        StringBuilder sb = new StringBuilder();
        boolean i1 = false;
        for (byte b : array) {
            if (!i1) {
                i1 = true;
            } else {
                sb.append(", ");
            }
            sb.append(b);
        }
        return sb.toString();
    }

    private String ArrayToString(long[] array) {
        StringBuilder sb = new StringBuilder();
        boolean i1 = false;
        for (long b : array) {
            if (!i1) {
                i1 = true;
            } else {
                sb.append(", ");
            }
            sb.append(b);
        }
        return sb.toString();
    }
}

