/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.primitives;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.GSMCharset;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.USSDString;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class USSDStringImpl
implements USSDString,
MAPAsnPrimitive {
    private String ussdString;
    private byte[] encodedString;
    private Charset charset;

    public USSDStringImpl() {
    }

    public USSDStringImpl(String ussdString, Charset charset) {
        this.ussdString = ussdString;
        this.charset = charset;
        if (this.charset == null) {
            this.charset = new GSMCharset("GSM", new String[0]);
        }
    }

    public USSDStringImpl(byte[] encodedString, Charset charset) {
        this.encodedString = encodedString;
        this.charset = charset;
        if (this.charset == null) {
            this.charset = new GSMCharset("GSM", new String[0]);
        }
    }

    public byte[] getEncodedString() {
        return this.encodedString;
    }

    public String getString() {
        return this.ussdString;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getTag() throws MAPException {
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.encodedString = asnIS.readOctetStringData(length);
        ByteBuffer bb = ByteBuffer.wrap(this.encodedString);
        if (this.charset == null) {
            this.charset = new GSMCharset("GSM", new String[0]);
        }
        CharBuffer bf = this.charset.decode(bb);
        this.ussdString = bf.toString();
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 4);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding reportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.ussdString == null) {
            throw new MAPException("Error while encoding USSDString the mandatory USSDString is not defined");
        }
        ByteBuffer bb = this.charset.encode(this.ussdString);
        this.encodedString = new byte[bb.limit()];
        int count = 0;
        while (bb.hasRemaining()) {
            this.encodedString[count++] = bb.get();
        }
        asnOs.writeOctetStringData(this.encodedString);
    }
}

