/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.service.lsm.AdditionalNumber;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class AdditionalNumberImpl
implements AdditionalNumber,
MAPAsnPrimitive {
    private static final int _TAG_MSC_NUMBER = 0;
    private static final int _TAG_SGSN_NUMBER = 1;
    private ISDNAddressString mSCNumber = null;
    private ISDNAddressString sGSNNumber = null;

    public AdditionalNumberImpl() {
    }

    public AdditionalNumberImpl(ISDNAddressString mSCNumber, ISDNAddressString sGSNNumber) {
        this.mSCNumber = mSCNumber;
        this.sGSNNumber = sGSNNumber;
    }

    public ISDNAddressString getMSCNumber() {
        return this.mSCNumber;
    }

    public ISDNAddressString getSGSNNumber() {
        return this.sGSNNumber;
    }

    public int getTag() throws MAPException {
        if (this.mSCNumber != null) {
            return 0;
        }
        return 1;
    }

    public int getTagClass() {
        return 2;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AdditionalNumber: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding AdditionalNumber: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        if (asnIS.getTagClass() != 2 || !asnIS.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding AdditionalNumber: bad tag class or is not primitive: TagClass=" + asnIS.getTagClass(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (asnIS.getTag()) {
            case 0: {
                this.mSCNumber = new ISDNAddressStringImpl();
                ((ISDNAddressStringImpl)this.mSCNumber).decodeData(asnIS, length);
                break;
            }
            case 1: {
                this.sGSNNumber = new ISDNAddressStringImpl();
                ((ISDNAddressStringImpl)this.sGSNNumber).decodeData(asnIS, length);
                break;
            }
            default: {
                throw new MAPParsingComponentException("Error while decoding AdditionalNumber: Expexted msc-Number [0] ISDN-AddressString or sgsn-Number [1] ISDN-AddressString, but found " + asnIS.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 2, this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding AdditionalNumber: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.mSCNumber != null) {
            ((ISDNAddressStringImpl)this.mSCNumber).encodeData(asnOs);
        } else {
            ((ISDNAddressStringImpl)this.sGSNNumber).encodeData(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AdditionalNumber [");
        if (this.mSCNumber != null) {
            sb.append("msc-Number=");
            sb.append(this.mSCNumber.toString());
        }
        if (this.sGSNNumber != null) {
            sb.append("sgsn-Number=");
            sb.append(this.sGSNNumber.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

