/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.lsm.AreaDefinition;
import org.mobicents.protocols.ss7.map.api.service.lsm.AreaEventInfo;
import org.mobicents.protocols.ss7.map.api.service.lsm.OccurrenceInfo;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.service.lsm.AreaDefinitionImpl;

public class AreaEventInfoImpl
implements AreaEventInfo,
MAPAsnPrimitive {
    private static final int _TAG_OCCURRENCE_INFO = 1;
    private static final int _TAG_INTERVAL_TIME = 2;
    private AreaDefinition areaDefinition = null;
    private OccurrenceInfo occurrenceInfo = null;
    private Integer intervalTime = null;

    public AreaEventInfoImpl() {
    }

    public AreaEventInfoImpl(AreaDefinition areaDefinition, OccurrenceInfo occurrenceInfo, Integer intervalTime) {
        this.areaDefinition = areaDefinition;
        this.occurrenceInfo = occurrenceInfo;
        this.intervalTime = intervalTime;
    }

    public AreaDefinition getAreaDefinition() {
        return this.areaDefinition;
    }

    public OccurrenceInfo getOccurrenceInfo() {
        return this.occurrenceInfo;
    }

    public Integer getIntervalTime() {
        return this.intervalTime;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (asnIS.getTagClass() != 2 || asnIS.isTagPrimitive() || tag != 0) {
            throw new MAPParsingComponentException("Error while decoding AreaEventInfo: Parameter 0 [areaDefinition [0] AreaDefinition] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.areaDefinition = new AreaDefinitionImpl();
        ((AreaDefinitionImpl)this.areaDefinition).decodeAll(ais);
        block4: while (ais.available() != 0) {
            switch (ais.readTag()) {
                case 1: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding AreaEventInfo: Parameter 1 [occurrenceInfo [1] OccurrenceInfo] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    int i1 = (int)ais.readInteger();
                    this.occurrenceInfo = OccurrenceInfo.getOccurrenceInfo((int)i1);
                    continue block4;
                }
                case 2: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding AreaEventInfo: Parameter 2 [intervalTime [2] IntervalTime] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.intervalTime = (int)ais.readInteger();
                    continue block4;
                }
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding reportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.areaDefinition == null) {
            throw new MAPException("Error while encoding AreaEventInfo the mandatory parameter[areaDefinition [0] AreaDefinition] is not defined");
        }
        ((AreaDefinitionImpl)this.areaDefinition).encodeAll(asnOs, 2, 0);
        try {
            if (this.occurrenceInfo != null) {
                asnOs.writeInteger(2, 1, (long)this.occurrenceInfo.getInfo());
            }
            if (this.intervalTime != null) {
                asnOs.writeInteger(2, 2, (long)this.intervalTime.intValue());
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding Area: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding Area: " + e.getMessage(), (Throwable)e);
        }
    }
}

