/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.lsm.Area;
import org.mobicents.protocols.ss7.map.api.service.lsm.AreaType;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class AreaImpl
implements Area,
MAPAsnPrimitive {
    private AreaType areaType = null;
    private byte[] areaIdentification = null;

    public AreaImpl() {
    }

    public AreaImpl(AreaType areaType, byte[] areaIdentification) {
        this.areaType = areaType;
        this.areaIdentification = areaIdentification;
    }

    public AreaType getAreaType() {
        return this.areaType;
    }

    public byte[] getAreaIdentification() {
        return this.areaIdentification;
    }

    public int getTag() throws MAPException {
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 0) {
            throw new MAPParsingComponentException("Error while decoding Area: Parameter 0 [areaType [0] AreaType] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        int i1 = (int)ais.readInteger();
        this.areaType = AreaType.getAreaType((int)i1);
        tag = ais.readTag();
        if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 1) {
            throw new MAPParsingComponentException("Error while decoding Area: Parameter 0 [areaIdentification [1] AreaIdentification] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.areaIdentification = ais.readOctetString();
        while (ais.available() != 0) {
            switch (ais.readTag()) {
                default: 
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding reportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.areaType == null) {
            throw new MAPException("Error while encoding Area the mandatory parameter[areaType [0] AreaType] is not defined");
        }
        if (this.areaIdentification == null) {
            throw new MAPException("Error while encoding Area the mandatory parameter[areaIdentification [1] AreaIdentification] is not defined");
        }
        try {
            asnOs.writeInteger(2, 0, (long)this.areaType.getType());
            asnOs.writeTag(2, true, 1);
            int pos2 = asnOs.StartContentDefiniteLength();
            asnOs.write(this.areaIdentification);
            asnOs.FinalizeContent(pos2);
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding Area: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding Area: " + e.getMessage(), (Throwable)e);
        }
    }
}

