/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.asn.BitSetStrictLength;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.lsm.DeferredLocationEventType;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class DeferredLocationEventTypeImpl
implements DeferredLocationEventType,
MAPAsnPrimitive {
    private static final int _INDEX_MS_AVAILABLE = 0;
    private static final int _INDEX__ENTERING_INTO_AREA = 1;
    private static final int _INDEX_LEAVING_FROM_AREA = 2;
    private static final int _INDEX_BEING_INSIDE_AREA = 3;
    private BitSetStrictLength bitString = new BitSetStrictLength(4);

    public DeferredLocationEventTypeImpl() {
    }

    public DeferredLocationEventTypeImpl(boolean msAvailable, boolean enteringIntoArea, boolean leavingFromArea, boolean beingInsideArea) {
        if (msAvailable) {
            this.bitString.set(0);
        }
        if (enteringIntoArea) {
            this.bitString.set(1);
        }
        if (leavingFromArea) {
            this.bitString.set(2);
        }
        if (beingInsideArea) {
            this.bitString.set(3);
        }
    }

    public int getTag() throws MAPException {
        return 3;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MWStatus: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MWStatus: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MWStatus: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MWStatus: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        if (length == 0 || length > 4) {
            throw new MAPParsingComponentException("Error decoding DeferredLocationEventType: the DeferredLocationEventType field must contain from 1 or 4 octets. Contains: " + length, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.bitString = ansIS.readBitStringData(length);
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 3);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MWStatus: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            asnOs.writeBitStringData(this.bitString);
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding MWStatus: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MWStatus: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean getMsAvailable() {
        return this.bitString.get(0);
    }

    public boolean getEnteringIntoArea() {
        return this.bitString.get(1);
    }

    public boolean getLeavingFromArea() {
        return this.bitString.get(2);
    }

    public boolean getBeingInsideArea() {
        return this.bitString.get(3);
    }
}

