/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSClientExternalID;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSClientID;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSClientInternalID;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSClientName;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSClientType;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSRequestorID;
import org.mobicents.protocols.ss7.map.primitives.AddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.service.lsm.LCSClientExternalIDImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LCSClientNameImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LCSRequestorIDImpl;

public class LCSClientIDImpl
implements LCSClientID,
MAPAsnPrimitive {
    private static final int _TAG_LCS_CLIENT_TYPE = 0;
    private static final int _TAG_LCS_CLIENT_EXTERNAL_ID = 1;
    private static final int _TAG_LCS_CLIENT_DIALED_BY_MS = 2;
    private static final int _TAG_LCS_CLIENT_INTERNAL_ID = 3;
    private static final int _TAG_LCS_CLIENT_NAME = 4;
    private static final int _TAG_LCS_APN = 5;
    private static final int _TAG_LCS_REQUESTOR_ID = 6;
    private LCSClientType lcsClientType = null;
    private LCSClientExternalID lcsClientExternalID = null;
    private LCSClientInternalID lcsClientInternalID = null;
    private LCSClientName lcsClientName = null;
    private AddressString lcsClientDialedByMS = null;
    private byte[] lcsAPN = null;
    private LCSRequestorID lcsRequestorID = null;

    public LCSClientIDImpl(LCSClientType lcsClientType, LCSClientExternalID lcsClientExternalID, LCSClientInternalID lcsClientInternalID, LCSClientName lcsClientName, AddressString lcsClientDialedByMS, byte[] lcsAPN, LCSRequestorID lcsRequestorID) {
        this.lcsClientType = lcsClientType;
        this.lcsClientExternalID = lcsClientExternalID;
        this.lcsClientInternalID = lcsClientInternalID;
        this.lcsClientName = lcsClientName;
        this.lcsClientDialedByMS = lcsClientDialedByMS;
        this.lcsAPN = lcsAPN;
        this.lcsRequestorID = lcsRequestorID;
    }

    public LCSClientIDImpl() {
    }

    public LCSClientType getLCSClientType() {
        return this.lcsClientType;
    }

    public LCSClientExternalID getLCSClientExternalID() {
        return this.lcsClientExternalID;
    }

    public AddressString getLCSClientDialedByMS() {
        return this.lcsClientDialedByMS;
    }

    public LCSClientInternalID getLCSClientInternalID() {
        return this.lcsClientInternalID;
    }

    public LCSClientName getLCSClientName() {
        return this.lcsClientName;
    }

    public byte[] getLCSAPN() {
        return this.lcsAPN;
    }

    public LCSRequestorID getLCSRequestorID() {
        return this.lcsRequestorID;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 0) {
            throw new MAPParsingComponentException("Error while decoding LCSClientID: Parameter 0[lcsClientType [0] LCSClientType] bad tag class, tag or not constructed", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        int length1 = ais.readLength();
        int lcsCltType = (int)ais.readIntegerData(length1);
        this.lcsClientType = LCSClientType.getLCSClientType((int)lcsCltType);
        block8: while (ais.available() != 0) {
            tag = ais.readTag();
            switch (tag) {
                case 1: {
                    if (ais.getTagClass() != 2 || ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding LCSClientExternalID: bad tag class, tag or not constructed", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.lcsClientExternalID = new LCSClientExternalIDImpl();
                    ((LCSClientExternalIDImpl)this.lcsClientExternalID).decodeAll(ais);
                    continue block8;
                }
                case 2: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding lcsClientDialedByMS: bad tag class, tag or not constructed", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.lcsClientDialedByMS = new AddressStringImpl();
                    ((AddressStringImpl)this.lcsClientDialedByMS).decodeAll(ais);
                    continue block8;
                }
                case 3: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding lcsClientInternalID: bad tag class, tag or not constructed", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    length1 = ais.readLength();
                    int i1 = (int)ais.readIntegerData(length1);
                    this.lcsClientInternalID = LCSClientInternalID.getLCSClientInternalID((int)i1);
                    continue block8;
                }
                case 4: {
                    if (ais.getTagClass() != 2 || ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding lcsClientName: bad tag class, tag or not constructed", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.lcsClientName = new LCSClientNameImpl();
                    ((LCSClientNameImpl)this.lcsClientName).decodeAll(ais);
                    continue block8;
                }
                case 5: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding lcsAPN: bad tag class, tag or not constructed", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    length1 = ais.readLength();
                    this.lcsAPN = ais.readOctetStringData(length1);
                    continue block8;
                }
                case 6: {
                    if (ais.getTagClass() != 2 || ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding lcsRequestorID: bad tag class, tag or not constructed", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.lcsRequestorID = new LCSRequestorIDImpl();
                    ((LCSRequestorIDImpl)this.lcsRequestorID).decodeAll(ais);
                    continue block8;
                }
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding LCSClientName", (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.lcsClientType == null) {
            throw new MAPException("lcsClientType must not be null");
        }
        try {
            asnOs.writeInteger(2, 0, (long)this.lcsClientType.getType());
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding parameter lcsClientType: ", (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding parameter lcsClientType: ", (Throwable)e);
        }
        if (this.lcsClientExternalID != null) {
            ((LCSClientExternalIDImpl)this.lcsClientExternalID).encodeAll(asnOs, 2, 1);
        }
        if (this.lcsClientDialedByMS != null) {
            ((AddressStringImpl)this.lcsClientDialedByMS).encodeAll(asnOs, 2, 2);
        }
        if (this.lcsClientInternalID != null) {
            try {
                asnOs.writeInteger(2, 3, (long)this.lcsClientInternalID.getId());
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding parameter lcsClientInternalID: ", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding parameter lcsClientInternalID: ", (Throwable)e);
            }
        }
        if (this.lcsClientName != null) {
            ((LCSClientNameImpl)this.lcsClientName).encodeAll(asnOs, 2, 4);
        }
        if (this.lcsAPN != null) {
            try {
                asnOs.writeOctetString(2, 5, this.lcsAPN);
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding parameter lcsAPN: ", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding parameter lcsAPN: ", (Throwable)e);
            }
        }
        if (this.lcsRequestorID != null) {
            ((LCSRequestorIDImpl)this.lcsRequestorID).encodeAll(asnOs, 2, 6);
        }
    }
}

