/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSPrivacyCheck;
import org.mobicents.protocols.ss7.map.api.service.lsm.PrivacyCheckRelatedAction;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class LCSPrivacyCheckImpl
implements LCSPrivacyCheck,
MAPAsnPrimitive {
    private static final int _TAG_CALL_SESSION_UNRELATED = 0;
    private static final int _TAG_CALL_SESSION_RELATED = 1;
    private PrivacyCheckRelatedAction callSessionUnrelated = null;
    private PrivacyCheckRelatedAction callSessionRelated = null;

    public LCSPrivacyCheckImpl() {
    }

    public LCSPrivacyCheckImpl(PrivacyCheckRelatedAction callSessionUnrelated, PrivacyCheckRelatedAction callSessionRelated) {
        this.callSessionUnrelated = callSessionUnrelated;
        this.callSessionRelated = callSessionRelated;
    }

    public PrivacyCheckRelatedAction getCallSessionUnrelated() {
        return this.callSessionUnrelated;
    }

    public PrivacyCheckRelatedAction getCallSessionRelated() {
        return this.callSessionRelated;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 0) {
            throw new MAPParsingComponentException("Error while decoding LCSPrivacyCheck: Parameter 0 [callSessionUnrelated [0] PrivacyCheckRelatedAction] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        int length1 = ais.readLength();
        int action = (int)ais.readIntegerData(length1);
        this.callSessionUnrelated = PrivacyCheckRelatedAction.getPrivacyCheckRelatedAction((int)action);
        block3: while (ais.available() != 0) {
            tag = ais.readTag();
            switch (tag) {
                case 1: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding LCSPrivacyCheck: Parameter 1 [callSessionRelated [1] PrivacyCheckRelatedAction] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    length1 = ais.readLength();
                    action = (int)ais.readIntegerData(length1);
                    this.callSessionRelated = PrivacyCheckRelatedAction.getPrivacyCheckRelatedAction((int)action);
                    continue block3;
                }
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding InformServiceCentreRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.callSessionUnrelated == null) {
            throw new MAPException("Error while encoding LCSPrivacyCheck the mandatory parameter callSessionUnrelated is not defined");
        }
        try {
            asnOs.writeInteger(2, 0, (long)this.callSessionUnrelated.getAction());
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding parameter callSessionUnrelated", (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding parameter callSessionUnrelated", (Throwable)e);
        }
        if (this.callSessionRelated != null) {
            try {
                asnOs.writeInteger(2, 1, (long)this.callSessionRelated.getAction());
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding parameter callSessionRelated", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding parameter callSessionRelated", (Throwable)e);
            }
        }
    }
}

