/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.lsm.DeferredLocationEventType;
import org.mobicents.protocols.ss7.map.api.service.lsm.LocationEstimateType;
import org.mobicents.protocols.ss7.map.api.service.lsm.LocationType;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.service.lsm.DeferredLocationEventTypeImpl;

public class LocationTypeImpl
implements LocationType,
MAPAsnPrimitive {
    private static final int _TAG_LOCATION_ESTIMATE_TYPE = 0;
    private static final int _TAG_DEFERRED_LOCATION_EVET_TYPE = 1;
    private LocationEstimateType locationEstimateType;
    private DeferredLocationEventType deferredLocationEventType;

    public LocationTypeImpl() {
    }

    public LocationTypeImpl(LocationEstimateType locationEstimateType, DeferredLocationEventType deferredLocationEventType) {
        this.locationEstimateType = locationEstimateType;
        this.deferredLocationEventType = deferredLocationEventType;
    }

    public LocationEstimateType getLocationEstimateType() {
        return this.locationEstimateType;
    }

    public DeferredLocationEventType getDeferredLocationEventType() {
        return this.deferredLocationEventType;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 0) {
            throw new MAPParsingComponentException("Error while decoding LocationType: Parameter 0[locationEstimateType [0] LocationEstimateType] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        int length1 = ais.readLength();
        int type = (int)ais.readIntegerData(length1);
        this.locationEstimateType = LocationEstimateType.getLocationEstimateType((int)type);
        block3: while (ais.available() != 0) {
            switch (ais.readTag()) {
                case 1: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding LocationType: Parameter 1 [deferredLocationEventType [1] DeferredLocationEventType] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.deferredLocationEventType = new DeferredLocationEventTypeImpl();
                    ((DeferredLocationEventTypeImpl)this.deferredLocationEventType).decodeAll(ais);
                    continue block3;
                }
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding reportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.locationEstimateType == null) {
            throw new MAPException("Error while encoding LocationType the mandatory parameter LocationEstimateType is not defined");
        }
        try {
            asnOs.writeInteger(2, 0, (long)this.locationEstimateType.getType());
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding parameter locationEstimateType: ", (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding parameter locationEstimateType: ", (Throwable)e);
        }
        if (this.deferredLocationEventType != null) {
            ((DeferredLocationEventTypeImpl)this.deferredLocationEventType).encodeAll(asnOs, 2, 1);
        }
    }
}

