/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.lsm.AccuracyFulfilmentIndicator;
import org.mobicents.protocols.ss7.map.api.service.lsm.CellGlobalIdOrServiceAreaIdOrLAI;
import org.mobicents.protocols.ss7.map.api.service.lsm.ProvideSubscriberLocationResponseIndication;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.lsm.CellGlobalIdOrServiceAreaIdOrLAIImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LsmMessageImpl;

public class ProvideSubscriberLocationResponseIndicationImpl
extends LsmMessageImpl
implements ProvideSubscriberLocationResponseIndication {
    private static final int _TAG_AGE_OF_LOCATION_ESTIMATE = 0;
    private static final int _TAG_EXTENSIONCONTAINER = 1;
    private static final int _TAG_ADD_LOCATION_ESTIMATE = 2;
    private static final int _TAG_DEFERRED_MT_LR_RESPONSE_IND = 3;
    private static final int _TAG_GERAN_POSITIONING_DATA = 4;
    private static final int _TAG_UTRAN_POSITIONING_DATA = 5;
    private static final int _TAG_CELL_ID_OR_SAI = 6;
    private static final int _TAG_SAI_PRESENT = 7;
    private static final int _TAG_ACCURACY_FULFILMENT_INDICATOR = 8;
    private byte[] locationEstimate = null;
    private byte[] geranPositioningData = null;
    private byte[] utranPositioningData = null;
    private Integer ageOfLocationEstimate = null;
    private byte[] additionalLocationEstimate = null;
    private MAPExtensionContainer extensionContainer = null;
    private Boolean deferredMTLRResponseIndicator = null;
    private CellGlobalIdOrServiceAreaIdOrLAI cellGlobalIdOrServiceAreaIdOrLAI = null;
    private Boolean saiPresent = null;
    private AccuracyFulfilmentIndicator accuracyFulfilmentIndicator = null;

    public ProvideSubscriberLocationResponseIndicationImpl() {
    }

    public ProvideSubscriberLocationResponseIndicationImpl(byte[] locationEstimate, byte[] geranPositioningData, byte[] utranPositioningData, Integer ageOfLocationEstimate, byte[] additionalLocationEstimate, MAPExtensionContainer extensionContainer, Boolean deferredMTLRResponseIndicator, CellGlobalIdOrServiceAreaIdOrLAI cellGlobalIdOrServiceAreaIdOrLAI, Boolean saiPresent, AccuracyFulfilmentIndicator accuracyFulfilmentIndicator) throws MAPException {
        if (locationEstimate == null || locationEstimate.length < 1 || locationEstimate.length > 20) {
            throw new MAPException("Mandatory parameter locationEstimate cannot be null or its length should be between 1 and 20 ");
        }
        if (ageOfLocationEstimate != null && (ageOfLocationEstimate < 0 || ageOfLocationEstimate > Short.MAX_VALUE)) {
            throw new MAPException("ageOfLocationEstimate cannot be less than 0 or greater than 32767");
        }
        this.locationEstimate = locationEstimate;
        this.geranPositioningData = geranPositioningData;
        this.utranPositioningData = utranPositioningData;
        this.ageOfLocationEstimate = ageOfLocationEstimate;
        this.additionalLocationEstimate = additionalLocationEstimate;
        this.extensionContainer = extensionContainer;
        this.deferredMTLRResponseIndicator = deferredMTLRResponseIndicator;
        this.cellGlobalIdOrServiceAreaIdOrLAI = cellGlobalIdOrServiceAreaIdOrLAI;
        this.saiPresent = saiPresent;
        this.accuracyFulfilmentIndicator = accuracyFulfilmentIndicator;
    }

    public byte[] getLocationEstimate() {
        return this.locationEstimate;
    }

    public byte[] getGeranPositioningData() {
        return this.geranPositioningData;
    }

    public byte[] getUtranPositioningData() {
        return this.utranPositioningData;
    }

    public Integer getAgeOfLocationEstimate() {
        return this.ageOfLocationEstimate;
    }

    public byte[] getAdditionalLocationEstimate() {
        return this.additionalLocationEstimate;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public Boolean getDeferredMTLRResponseIndicator() {
        return this.deferredMTLRResponseIndicator;
    }

    public CellGlobalIdOrServiceAreaIdOrLAI getCellGlobalIdOrServiceAreaIdOrLAI() {
        return this.cellGlobalIdOrServiceAreaIdOrLAI;
    }

    public Boolean getSaiPresent() {
        return this.saiPresent;
    }

    public AccuracyFulfilmentIndicator getAccuracyFulfilmentIndicator() {
        return this.accuracyFulfilmentIndicator;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ProvideSubscriberLocationRequestIndication: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ProvideSubscriberLocationRequestIndication: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ProvideSubscriberLocationRequestIndication: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ProvideSubscriberLocationRequestIndication: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 16) {
            throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationResponseIndication: Parameter [locationEstimate Ext-GeographicalInformation] bad tag class or not constructed", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        block11: while (ais.available() != 0) {
            tag = ais.readTag();
            switch (tag) {
                case 0: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationResponseIndication: Parameter [ageOfLocationEstimate [0] AgeOfLocationInformation] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    int length1 = ais.readLength();
                    this.ageOfLocationEstimate = (int)ais.readIntegerData(length1);
                    continue block11;
                }
                case 1: {
                    if (ais.getTagClass() != 2 || ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationResponseIndication: Parameter [extensionContainer [1] ExtensionContainer] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.extensionContainer = new MAPExtensionContainerImpl();
                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                    continue block11;
                }
                case 2: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationResponseIndication: Parameter [add-LocationEstimate [2] Add-GeographicalInformation] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    int length1 = ais.readLength();
                    this.additionalLocationEstimate = ais.readOctetStringData(length1);
                    continue block11;
                }
                case 3: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationResponseIndication: Parameter [deferredmt-lrResponseIndicator [3] NULL] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    int length1 = ais.readLength();
                    this.deferredMTLRResponseIndicator = true;
                    continue block11;
                }
                case 4: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationResponseIndication: Parameter [geranPositioningData [4] PositioningDataInformation] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    int length1 = ais.readLength();
                    this.geranPositioningData = ais.readOctetStringData(length1);
                    continue block11;
                }
                case 5: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationResponseIndication: Parameter [utranPositioningData [5] UtranPositioningDataInfo] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    int length1 = ais.readLength();
                    this.utranPositioningData = ais.readOctetStringData(length1);
                    continue block11;
                }
                case 6: {
                    if (ais.getTagClass() != 2 || ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationResponseIndication: Parameter [cellIdOrSai [6] CellGlobalIdOrServiceAreaIdOrLAI] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.cellGlobalIdOrServiceAreaIdOrLAI = new CellGlobalIdOrServiceAreaIdOrLAIImpl();
                    ((CellGlobalIdOrServiceAreaIdOrLAIImpl)this.cellGlobalIdOrServiceAreaIdOrLAI).decodeAll(ais);
                    continue block11;
                }
                case 7: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationResponseIndication: Parameter [sai-Present [7] NULL] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    int length1 = ais.readLength();
                    this.saiPresent = true;
                    continue block11;
                }
                case 8: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationResponseIndication: Parameter [accuracyFulfilmentIndicator [8] AccuracyFulfilmentIndicator] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    int length1 = ais.readLength();
                    int indicator = (int)ais.readIntegerData(length1);
                    this.accuracyFulfilmentIndicator = AccuracyFulfilmentIndicator.getAccuracyFulfilmentIndicator((int)indicator);
                    continue block11;
                }
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MWStatus: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.locationEstimate == null) {
            throw new MAPException("Error while encoding ProvideSubscriberLocation-Res the mandatory parameter locationEstimate is not defined");
        }
        try {
            asnOs.writeOctetString(this.locationEstimate);
        }
        catch (IOException e) {
            throw new MAPException("IOException while encoding parameter locationEstimate", (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException while encoding parameter locationEstimate", (Throwable)e);
        }
        if (this.ageOfLocationEstimate != null) {
            try {
                asnOs.writeInteger(2, 0, (long)this.ageOfLocationEstimate.intValue());
            }
            catch (IOException e) {
                throw new MAPException("IOException while encoding parameter ageOfLocationEstimate", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException while encoding parameter ageOfLocationEstimate", (Throwable)e);
            }
        }
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 1);
        }
        if (this.additionalLocationEstimate != null) {
            try {
                asnOs.writeOctetString(2, 2, this.additionalLocationEstimate);
            }
            catch (IOException e) {
                throw new MAPException("IOException while encoding parameter additionalLocationEstimate", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException while encoding parameter additionalLocationEstimate", (Throwable)e);
            }
        }
        if (this.deferredMTLRResponseIndicator != null) {
            try {
                asnOs.writeNull(2, 3);
            }
            catch (IOException e) {
                throw new MAPException("IOException while encoding parameter deferredMTLRResponseIndicator", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException while encoding parameter deferredMTLRResponseIndicator", (Throwable)e);
            }
        }
        if (this.geranPositioningData != null) {
            try {
                asnOs.writeOctetString(2, 4, this.geranPositioningData);
            }
            catch (IOException e) {
                throw new MAPException("IOException while encoding parameter geranPositioningData", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException while encoding parameter geranPositioningData", (Throwable)e);
            }
        }
        if (this.utranPositioningData != null) {
            try {
                asnOs.writeOctetString(2, 5, this.utranPositioningData);
            }
            catch (IOException e) {
                throw new MAPException("IOException while encoding parameter utranPositioningData", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException while encoding parameter utranPositioningData", (Throwable)e);
            }
        }
        if (this.cellGlobalIdOrServiceAreaIdOrLAI != null) {
            ((CellGlobalIdOrServiceAreaIdOrLAIImpl)this.cellGlobalIdOrServiceAreaIdOrLAI).encodeAll(asnOs);
        }
        if (this.saiPresent != null) {
            try {
                asnOs.writeNull(2, 7);
            }
            catch (IOException e) {
                throw new MAPException("IOException while encoding parameter saiPresent", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException while encoding parameter saiPresent", (Throwable)e);
            }
        }
    }
}

