/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.lsm.ResponseTime;
import org.mobicents.protocols.ss7.map.api.service.lsm.ResponseTimeCategory;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class ResponseTimeImpl
implements ResponseTime,
MAPAsnPrimitive {
    private ResponseTimeCategory responseTimeCategory = null;

    public ResponseTimeImpl() {
    }

    public ResponseTimeImpl(ResponseTimeCategory responseTimeCategory) {
        this.responseTimeCategory = responseTimeCategory;
    }

    public ResponseTimeCategory getResponseTimeCategory() {
        return this.responseTimeCategory;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 10) {
            throw new MAPParsingComponentException("Error while decoding ResponseTime: Parameter 0[ResponseTimeCategory ::= ENUMERATED] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        int length1 = ais.readLength();
        int category = (int)ais.readIntegerData(length1);
        this.responseTimeCategory = ResponseTimeCategory.getResponseTimeCategory((int)category);
        while (ais.available() != 0) {
            switch (ais.readTag()) {
                default: 
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding InformServiceCentreRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.responseTimeCategory == null) {
            throw new MAPException("Error while encoding ResponseTime the mandatory parameter responseTimeCategory is not defined");
        }
        try {
            asnOs.writeInteger(0, 10, (long)this.responseTimeCategory.getCategory());
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding responseTimeCategory: ", (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding responseTimeCategory: ", (Throwable)e);
        }
    }
}

