/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.service.lsm.SubscriberIdentity;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class SubscriberIdentityImpl
implements SubscriberIdentity,
MAPAsnPrimitive {
    private static final int _TAG_IMSI = 0;
    private static final int _TAG_MSISDN = 1;
    private IMSI imsi = null;
    private ISDNAddressString msisdn = null;

    public SubscriberIdentityImpl() {
    }

    public SubscriberIdentityImpl(IMSI imsi) {
        this.imsi = imsi;
        this.msisdn = null;
    }

    public SubscriberIdentityImpl(ISDNAddressString msisdn) {
        this.msisdn = msisdn;
        this.imsi = null;
    }

    public IMSI getIMSI() {
        return this.imsi;
    }

    public ISDNAddressString getMSISDN() {
        return this.msisdn;
    }

    public int getTag() throws MAPException {
        if (this.imsi != null) {
            return 0;
        }
        return 1;
    }

    public int getTagClass() {
        return 2;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SubscriberIdentity: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SubscriberIdentity: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        if (asnIS.getTagClass() != 2 || !asnIS.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding SubscriberIdentity: bad tag class or is not primitive: TagClass=" + asnIS.getTagClass(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (asnIS.getTag()) {
            case 0: {
                this.imsi = new IMSIImpl();
                ((IMSIImpl)this.imsi).decodeData(asnIS, length);
                break;
            }
            case 1: {
                this.msisdn = new ISDNAddressStringImpl();
                ((ISDNAddressStringImpl)this.msisdn).decodeData(asnIS, length);
                break;
            }
            default: {
                throw new MAPParsingComponentException("Error while decoding SubscriberIdentity: Expexted imsi [0] IMSI or msisdn [1] ISDN-AddressString, but found " + asnIS.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 2, this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding AdditionalNumber: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.imsi != null) {
            ((IMSIImpl)this.imsi).encodeData(asnOs);
        } else {
            ((ISDNAddressStringImpl)this.msisdn).encodeData(asnOs);
        }
    }
}

