/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.asn.BitSetStrictLength;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.lsm.SupportedGADShapes;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class SupportedGADShapesImpl
implements SupportedGADShapes,
MAPAsnPrimitive {
    private static final int _INDEX_ELLIPSOID_POINT = 0;
    private static final int _INDEX_ELLIPSOID_POINT_WITH_UNCERTAINTY_CIRCLE = 1;
    private static final int _INDEX_ELLIPSOID_POINT_WITH_UNCERTAINTY_ELLIPSE = 2;
    private static final int _INDEX_POLYGON = 3;
    private static final int _INDEX_ELLIPSOID_POINT_WITH_ALTITUDE = 4;
    private static final int _INDEX_ELLIPSOID_WITH_ALTITUDE_AND_UNCERTAINTY_ELIPSOID = 5;
    private static final int _INDEX_ELLIPSOID_ARC = 6;
    private BitSetStrictLength bitString = new BitSetStrictLength(7);

    public SupportedGADShapesImpl() {
    }

    public SupportedGADShapesImpl(boolean ellipsoidPoint, boolean ellipsoidPointWithUncertaintyCircle, boolean ellipsoidPointWithUncertaintyEllipse, boolean polygon, boolean ellipsoidPointWithAltitude, boolean ellipsoidPointWithAltitudeAndUncertaintyElipsoid, boolean ellipsoidArc) {
        if (ellipsoidPoint) {
            this.bitString.set(0);
        }
        if (ellipsoidPointWithUncertaintyCircle) {
            this.bitString.set(1);
        }
        if (ellipsoidPointWithUncertaintyEllipse) {
            this.bitString.set(2);
        }
        if (polygon) {
            this.bitString.set(3);
        }
        if (ellipsoidPointWithAltitude) {
            this.bitString.set(4);
        }
        if (ellipsoidPointWithAltitudeAndUncertaintyElipsoid) {
            this.bitString.set(5);
        }
        if (ellipsoidArc) {
            this.bitString.set(6);
        }
    }

    public int getTag() throws MAPException {
        return 3;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MWStatus: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MWStatus: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MWStatus: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MWStatus: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        if (length == 0 || length > 7) {
            throw new MAPParsingComponentException("Error decoding SupportedGADShapes: the SupportedGADShapes field must contain from 7 octets. Contains: " + length, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.bitString = ansIS.readBitStringData(length);
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 3);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MWStatus: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            asnOs.writeBitStringData(this.bitString);
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding MWStatus: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MWStatus: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean getEllipsoidPoint() {
        return this.bitString.get(0);
    }

    public boolean getEllipsoidPointWithUncertaintyCircle() {
        return this.bitString.get(1);
    }

    public boolean getEllipsoidPointWithUncertaintyEllipse() {
        return this.bitString.get(2);
    }

    public boolean getPolygon() {
        return this.bitString.get(3);
    }

    public boolean getEllipsoidPointWithAltitude() {
        return this.bitString.get(4);
    }

    public boolean getEllipsoidPointWithAltitudeAndUncertaintyElipsoid() {
        return this.bitString.get(5);
    }

    public boolean getEllipsoidArc() {
        return this.bitString.get(6);
    }
}

