/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.sms;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.sms.ReportSMDeliveryStatusRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.sms.SMDeliveryOutcome;
import org.mobicents.protocols.ss7.map.primitives.AddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.sms.SmsMessageImpl;

public class ReportSMDeliveryStatusRequestIndicationImpl
extends SmsMessageImpl
implements ReportSMDeliveryStatusRequestIndication {
    protected static final int _TAG_AbsentSubscriberDiagnosticSM = 0;
    protected static final int _TAG_ExtensionContainer = 1;
    protected static final int _TAG_GprsSupportIndicator = 2;
    protected static final int _TAG_DeliveryOutcomeIndicator = 3;
    protected static final int _TAG_AdditionalSMDeliveryOutcome = 4;
    protected static final int _TAG_AdditionalAbsentSubscriberDiagnosticSM = 5;
    private ISDNAddressString msisdn;
    private AddressString serviceCentreAddress;
    private SMDeliveryOutcome sMDeliveryOutcome;
    private Integer absentSubscriberDiagnosticSM;
    private MAPExtensionContainer extensionContainer;
    private boolean gprsSupportIndicator;
    private boolean deliveryOutcomeIndicator;
    private SMDeliveryOutcome additionalSMDeliveryOutcome;
    private Integer additionalAbsentSubscriberDiagnosticSM;
    private long mapProtocolVersion;

    public ReportSMDeliveryStatusRequestIndicationImpl(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public ReportSMDeliveryStatusRequestIndicationImpl(long mapProtocolVersion, ISDNAddressString msisdn, AddressString serviceCentreAddress, SMDeliveryOutcome sMDeliveryOutcome, Integer absentSubscriberDiagnosticSM, MAPExtensionContainer extensionContainer, boolean gprsSupportIndicator, boolean deliveryOutcomeIndicator, SMDeliveryOutcome additionalSMDeliveryOutcome, Integer additionalAbsentSubscriberDiagnosticSM) {
        this.mapProtocolVersion = mapProtocolVersion;
        this.msisdn = msisdn;
        this.serviceCentreAddress = serviceCentreAddress;
        this.sMDeliveryOutcome = sMDeliveryOutcome;
        this.absentSubscriberDiagnosticSM = absentSubscriberDiagnosticSM;
        this.extensionContainer = extensionContainer;
        this.gprsSupportIndicator = gprsSupportIndicator;
        this.deliveryOutcomeIndicator = deliveryOutcomeIndicator;
        this.additionalSMDeliveryOutcome = additionalSMDeliveryOutcome;
        this.additionalAbsentSubscriberDiagnosticSM = additionalAbsentSubscriberDiagnosticSM;
    }

    public ISDNAddressString getMsisdn() {
        return this.msisdn;
    }

    public AddressString getServiceCentreAddress() {
        return this.serviceCentreAddress;
    }

    public SMDeliveryOutcome getSMDeliveryOutcome() {
        return this.sMDeliveryOutcome;
    }

    public Integer getAbsentSubscriberDiagnosticSM() {
        return this.absentSubscriberDiagnosticSM;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public boolean getGprsSupportIndicator() {
        return this.gprsSupportIndicator;
    }

    public boolean getDeliveryOutcomeIndicator() {
        return this.deliveryOutcomeIndicator;
    }

    public SMDeliveryOutcome getAdditionalSMDeliveryOutcome() {
        return this.additionalSMDeliveryOutcome;
    }

    public Integer getAdditionalAbsentSubscriberDiagnosticSM() {
        return this.additionalAbsentSubscriberDiagnosticSM;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.msisdn = null;
        this.serviceCentreAddress = null;
        this.sMDeliveryOutcome = null;
        this.absentSubscriberDiagnosticSM = null;
        this.extensionContainer = null;
        this.gprsSupportIndicator = false;
        this.deliveryOutcomeIndicator = false;
        this.additionalSMDeliveryOutcome = null;
        this.additionalAbsentSubscriberDiagnosticSM = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (tag != 4 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding ReportSMDeliveryStatusRequest.msisdn: Parameter bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.msisdn = new ISDNAddressStringImpl();
                    ((ISDNAddressStringImpl)this.msisdn).decodeAll(ais);
                    break;
                }
                case 1: {
                    if (tag != 4 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding ReportSMDeliveryStatusRequest.serviceCentreAddress: Parameter bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.serviceCentreAddress = new AddressStringImpl();
                    ((AddressStringImpl)this.serviceCentreAddress).decodeAll(ais);
                    break;
                }
                case 2: {
                    if (tag != 10 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding ReportSMDeliveryStatusRequest.sMDeliveryOutcome: Parameter bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    int i1 = (int)ais.readInteger();
                    this.sMDeliveryOutcome = SMDeliveryOutcome.getInstance((int)i1);
                    break;
                }
                default: {
                    int i1;
                    if (ais.getTagClass() == 2) {
                        switch (tag) {
                            case 0: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding reportSMDeliveryStatusRequest: Parameter absentSubscriberDiagnosticSM is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.absentSubscriberDiagnosticSM = (int)ais.readInteger();
                                break block0;
                            }
                            case 1: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding reportSMDeliveryStatusRequest: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.extensionContainer = new MAPExtensionContainerImpl();
                                ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                break block0;
                            }
                            case 2: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding reportSMDeliveryStatusRequest: Parameter gprsSupportIndicator is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.gprsSupportIndicator = true;
                                break block0;
                            }
                            case 3: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding reportSMDeliveryStatusRequest: Parameter deliveryOutcomeIndicator is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.deliveryOutcomeIndicator = true;
                                break block0;
                            }
                            case 4: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding reportSMDeliveryStatusRequest: Parameter additionalSMDeliveryOutcome is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                i1 = (int)ais.readInteger();
                                this.additionalSMDeliveryOutcome = SMDeliveryOutcome.getInstance((int)i1);
                                break block0;
                            }
                            case 5: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding reportSMDeliveryStatusRequest: Parameter additionalAbsentSubscriberDiagnosticSM is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.additionalAbsentSubscriberDiagnosticSM = (int)ais.readInteger();
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (num < 3 && this.mapProtocolVersion >= 2L || num < 2 && this.mapProtocolVersion == 1L) {
            throw new MAPParsingComponentException("Error while decoding reportSMDeliveryStatusRequest: Needs at least 3 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding reportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.mapProtocolVersion == 1L) {
            if (this.msisdn == null || this.serviceCentreAddress == null) {
                throw new MAPException("msisdn and serviceCentreAddress must not be null");
            }
        } else if (this.msisdn == null || this.serviceCentreAddress == null || this.sMDeliveryOutcome == null) {
            throw new MAPException("msisdn, serviceCentreAddress and sMDeliveryOutcome must not be null");
        }
        try {
            ((ISDNAddressStringImpl)this.msisdn).encodeAll(asnOs);
            ((AddressStringImpl)this.serviceCentreAddress).encodeAll(asnOs);
            if (this.mapProtocolVersion >= 1L) {
                asnOs.writeInteger(0, 10, (long)this.sMDeliveryOutcome.getCode());
            }
            if (this.absentSubscriberDiagnosticSM != null) {
                asnOs.writeInteger(2, 0, (long)this.absentSubscriberDiagnosticSM.intValue());
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 1);
            }
            if (this.gprsSupportIndicator) {
                asnOs.writeNull(2, 2);
            }
            if (this.deliveryOutcomeIndicator) {
                asnOs.writeNull(2, 3);
            }
            if (this.additionalSMDeliveryOutcome != null) {
                asnOs.writeInteger(2, 4, (long)this.additionalSMDeliveryOutcome.getCode());
            }
            if (this.additionalAbsentSubscriberDiagnosticSM != null) {
                asnOs.writeInteger(2, 5, (long)this.additionalAbsentSubscriberDiagnosticSM.intValue());
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding mtForwardShortMessageRequest: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding mtForwardShortMessageRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReportSMDeliveryStatusRequest [");
        if (this.msisdn != null) {
            sb.append("msisdn=");
            sb.append(this.msisdn.toString());
        }
        if (this.serviceCentreAddress != null) {
            sb.append(", serviceCentreAddress=");
            sb.append(this.serviceCentreAddress.toString());
        }
        if (this.sMDeliveryOutcome != null) {
            sb.append(", sMDeliveryOutcome=");
            sb.append(this.sMDeliveryOutcome.toString());
        }
        if (this.absentSubscriberDiagnosticSM != null) {
            sb.append(", absentSubscriberDiagnosticSM=");
            sb.append(this.absentSubscriberDiagnosticSM.toString());
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer.toString());
        }
        if (this.gprsSupportIndicator) {
            sb.append(", gprsSupportIndicator");
        }
        if (this.deliveryOutcomeIndicator) {
            sb.append(", deliveryOutcomeIndicator");
        }
        if (this.additionalSMDeliveryOutcome != null) {
            sb.append(", additionalSMDeliveryOutcome=");
            sb.append(this.additionalSMDeliveryOutcome.toString());
        }
        if (this.additionalAbsentSubscriberDiagnosticSM != null) {
            sb.append(", additionalAbsentSubscriberDiagnosticSM=");
            sb.append(this.additionalAbsentSubscriberDiagnosticSM.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

