/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.supplementary;

import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.ss7.map.MAPDialogImpl;
import org.mobicents.protocols.ss7.map.MAPProviderImpl;
import org.mobicents.protocols.ss7.map.MAPServiceBaseImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.MAPServiceListener;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckData;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckResult;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.service.supplementary.MAPDialogSupplementary;
import org.mobicents.protocols.ss7.map.api.service.supplementary.MAPServiceSupplementary;
import org.mobicents.protocols.ss7.map.api.service.supplementary.MAPServiceSupplementaryListener;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ProcessUnstructuredSSRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ProcessUnstructuredSSResponseIndication;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSNotifyRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSResponseIndication;
import org.mobicents.protocols.ss7.map.dialog.ServingCheckDataImpl;
import org.mobicents.protocols.ss7.map.service.sms.MAPServiceSmsImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.MAPDialogSupplementaryImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.ProcessUnstructuredSSRequestIndicationImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.ProcessUnstructuredSSResponseIndicationImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.UnstructuredSSNotifyRequestIndicationImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.UnstructuredSSRequestIndicationImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.UnstructuredSSResponseIndicationImpl;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;

public class MAPServiceSupplementaryImpl
extends MAPServiceBaseImpl
implements MAPServiceSupplementary {
    private static final Logger loger = Logger.getLogger(MAPServiceSmsImpl.class);

    public MAPServiceSupplementaryImpl(MAPProviderImpl mapProviderImpl) {
        super(mapProviderImpl);
    }

    public MAPDialogSupplementary createNewDialog(MAPApplicationContext appCntx, SccpAddress origAddress, AddressString origReference, SccpAddress destAddress, AddressString destReference) throws MAPException {
        if (!this.isActivated()) {
            throw new MAPException("Cannot create MAPDialogSupplementary because MAPServiceSupplementary is not activated");
        }
        Dialog tcapDialog = this.createNewTCAPDialog(origAddress, destAddress);
        MAPDialogSupplementaryImpl dialog = new MAPDialogSupplementaryImpl(appCntx, tcapDialog, this.mapProviderImpl, this, origReference, destReference);
        this.PutMADDialogIntoCollection(dialog);
        return dialog;
    }

    protected MAPDialogImpl createNewDialogIncoming(MAPApplicationContext appCntx, Dialog tcapDialog) {
        return new MAPDialogSupplementaryImpl(appCntx, tcapDialog, this.mapProviderImpl, this, null, null);
    }

    public void addMAPServiceListener(MAPServiceSupplementaryListener mapServiceListener) {
        super.addMAPServiceListener((MAPServiceListener)mapServiceListener);
    }

    public void removeMAPServiceListener(MAPServiceSupplementaryListener mapServiceListener) {
        super.removeMAPServiceListener((MAPServiceListener)mapServiceListener);
    }

    public ServingCheckData isServingService(MAPApplicationContext dialogApplicationContext) {
        MAPApplicationContextName ctx = dialogApplicationContext.getApplicationContextName();
        int vers = dialogApplicationContext.getApplicationContextVersion().getVersion();
        switch (ctx) {
            case networkUnstructuredSsContext: {
                if (vers == 2) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 2) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 2L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName((long[])altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
        }
        return new ServingCheckDataImpl(ServingCheckResult.AC_NotServing);
    }

    public void processComponent(ComponentType compType, OperationCode oc, Parameter parameter, MAPDialog mapDialog, Long invokeId, Long linkedId) throws MAPParsingComponentException {
        MAPDialogSupplementaryImpl mapDialogSupplementaryImpl = (MAPDialogSupplementaryImpl)mapDialog;
        Long ocValue = oc.getLocalOperationCode();
        if (ocValue == null) {
            new MAPParsingComponentException("", MAPParsingComponentExceptionReason.UnrecognizedOperation);
        }
        long ocValueInt = ocValue;
        int ocValueInt2 = (int)ocValueInt;
        switch (ocValueInt2) {
            case 59: {
                if (compType == ComponentType.Invoke) {
                    this.processUnstructuredSSRequest(parameter, mapDialogSupplementaryImpl, invokeId);
                    break;
                }
                this.processUnstructuredSSResponse(parameter, mapDialogSupplementaryImpl, invokeId);
                break;
            }
            case 60: {
                if (compType == ComponentType.Invoke) {
                    this.unstructuredSSRequest(parameter, mapDialogSupplementaryImpl, invokeId);
                    break;
                }
                this.unstructuredSSResponse(parameter, mapDialogSupplementaryImpl, invokeId);
                break;
            }
            case 61: {
                if (compType != ComponentType.Invoke) break;
                this.unstructuredSSNotifyRequest(parameter, mapDialogSupplementaryImpl, invokeId);
            }
            default: {
                new MAPParsingComponentException("", MAPParsingComponentExceptionReason.UnrecognizedOperation);
            }
        }
    }

    private void unstructuredSSNotifyRequest(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding unstructuredSSNotifyIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding unstructuredSSNotifyIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        UnstructuredSSNotifyRequestIndicationImpl ind = new UnstructuredSSNotifyRequestIndicationImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSupplementaryListener)serLis).onUnstructuredSSNotifyRequestIndication((UnstructuredSSNotifyRequestIndication)ind);
            }
            catch (Exception e) {
                loger.error((Object)("Error processing unstructuredSSNotifyIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void unstructuredSSNotifyResponse(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding unstructuredSSNotifyIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding unstructuredSSNotifyIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        UnstructuredSSNotifyRequestIndicationImpl ind = new UnstructuredSSNotifyRequestIndicationImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSupplementaryListener)serLis).onUnstructuredSSNotifyRequestIndication((UnstructuredSSNotifyRequestIndication)ind);
            }
            catch (Exception e) {
                loger.error((Object)("Error processing unstructuredSSNotifyIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void unstructuredSSRequest(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding UnstructuredSSRequestIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding UnstructuredSSRequestIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        UnstructuredSSRequestIndicationImpl ind = new UnstructuredSSRequestIndicationImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSupplementaryListener)serLis).onUnstructuredSSRequestIndication((UnstructuredSSRequestIndication)ind);
            }
            catch (Exception e) {
                loger.error((Object)("Error processing UnstructuredSSRequestIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void unstructuredSSResponse(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding UnstructuredSSResponseIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding UnstructuredSSResponseIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        UnstructuredSSResponseIndicationImpl ind = new UnstructuredSSResponseIndicationImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSupplementaryListener)serLis).onUnstructuredSSResponseIndication((UnstructuredSSResponseIndication)ind);
            }
            catch (Exception e) {
                loger.error((Object)("Error processing UnstructuredSSResponseIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processUnstructuredSSRequest(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding ProcessUnstructuredSSRequestIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding ProcessUnstructuredSSRequestIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ProcessUnstructuredSSRequestIndicationImpl ind = new ProcessUnstructuredSSRequestIndicationImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSupplementaryListener)serLis).onProcessUnstructuredSSRequestIndication((ProcessUnstructuredSSRequestIndication)ind);
            }
            catch (Exception e) {
                loger.error((Object)("Error processing ProcessUnstructuredSSRequestIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processUnstructuredSSResponse(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding ProcessUnstructuredSSResponseIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding ProcessUnstructuredSSResponseIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ProcessUnstructuredSSResponseIndicationImpl ind = new ProcessUnstructuredSSResponseIndicationImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSupplementaryListener)serLis).onProcessUnstructuredSSResponseIndication((ProcessUnstructuredSSResponseIndication)ind);
            }
            catch (Exception e) {
                loger.error((Object)("Error processing ProcessUnstructuredSSResponseIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

