/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.impl.router.RouterImpl;
import org.mobicents.ss7.RemSignalingGateway;
import org.mobicents.ss7.SS7ServiceMBean;
import org.mobicents.ss7.ShellExecutor;
import org.mobicents.ss7.linkset.oam.Linkset;
import org.mobicents.ss7.linkset.oam.LinksetManager;

public class SS7Service
extends ServiceMBeanSupport
implements SS7ServiceMBean {
    private ShellExecutor shellExecutor = null;
    private RemSignalingGateway remSignalingGateway = null;
    private LinksetManager linksetManager;
    private SccpStackImpl sccpStack;
    private RouterImpl routerImpl;
    private String path;
    private String jndiName;
    private Logger logger = Logger.getLogger(SS7Service.class);

    public void startService() throws Exception {
        this.logger.info((Object)"Starting SCCP stack...");
        this.sccpStack = new SccpStackImpl();
        this.sccpStack.setConfigPath(this.path);
        this.sccpStack.setRouter(this.routerImpl);
        FastMap map = this.linksetManager.getLinksets();
        FastMap.Entry e = map.head();
        FastMap.Entry end = map.tail();
        while ((e = e.getNext()) != end) {
            Linkset value = (Linkset)e.getValue();
            this.sccpStack.add(value);
        }
        this.sccpStack.start();
        this.rebind(this.sccpStack);
        this.logger.info((Object)("SCCP stack Started. SccpProvider bound to " + this.jndiName));
        if (this.shellExecutor != null) {
            this.shellExecutor.startService();
        }
        if (this.remSignalingGateway != null) {
            this.remSignalingGateway.startService();
        }
        this.logger.info((Object)"[[[[[[[[[ Mobicents SS7 service started ]]]]]]]]]");
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setConfigPath(String path) {
        this.path = path;
    }

    public ShellExecutor getShellExecutor() {
        return this.shellExecutor;
    }

    public void setShellExecutor(ShellExecutor shellExecutor) {
        this.shellExecutor = shellExecutor;
    }

    public RemSignalingGateway getRemSignalingGateway() {
        return this.remSignalingGateway;
    }

    public void setRemSignalingGateway(RemSignalingGateway remSignalingGateway) {
        this.remSignalingGateway = remSignalingGateway;
    }

    public RouterImpl getRouterImpl() {
        return this.routerImpl;
    }

    public void setRouterImpl(RouterImpl routerImpl) {
        this.routerImpl = routerImpl;
    }

    public void stopService() {
        try {
            this.unbind(this.jndiName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.shellExecutor != null) {
            this.shellExecutor.stopService();
        }
        if (this.remSignalingGateway != null) {
            this.remSignalingGateway.stopService();
        }
        this.logger.info((Object)"Stopped SS7 service");
    }

    public void setLinksetManager(LinksetManager manager) {
        this.linksetManager = manager;
    }

    public LinksetManager getLinksetManager() {
        return this.linksetManager;
    }

    private void rebind(SccpStackImpl stack) throws NamingException {
        Context ctx = new InitialContext();
        String[] tokens = this.jndiName.split("/");
        for (int i = 0; i < tokens.length - 1; ++i) {
            if (tokens[i].trim().length() <= 0) continue;
            try {
                ctx = (Context)ctx.lookup(tokens[i]);
                continue;
            }
            catch (NamingException e) {
                ctx = ctx.createSubcontext(tokens[i]);
            }
        }
        ctx.bind(tokens[tokens.length - 1], (Object)stack.getSccpProvider());
    }

    private void unbind(String jndiName) throws NamingException {
        InitialContext initialContext = new InitialContext();
        initialContext.unbind(jndiName);
    }
}

