/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.parameter;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.indicator.EncodingScheme;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.indicator.NatureOfAddress;
import org.mobicents.protocols.ss7.indicator.NumberingPlan;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;

public class GT0100
extends GlobalTitle {
    private static final GlobalTitleIndicator gti = GlobalTitleIndicator.GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_ENCODING_SCHEME_AND_NATURE_OF_ADDRESS;
    private int tt;
    private NumberingPlan np;
    private EncodingScheme encodingScheme;
    private NatureOfAddress nai;
    private String digits = "";
    protected static final XMLFormat<GT0100> XML = new XMLFormat<GT0100>(GT0100.class){

        public void write(GT0100 ai, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("tt", ai.tt);
            xml.setAttribute("es", ai.encodingScheme.getValue());
            xml.setAttribute("np", ai.np.getValue());
            xml.setAttribute("nai", ai.nai.getValue());
            xml.setAttribute("digits", ai.digits);
        }

        public void read(XMLFormat.InputElement xml, GT0100 ai) throws XMLStreamException {
            ai.tt = xml.getAttribute("tt").toInt();
            ai.encodingScheme = EncodingScheme.valueOf(xml.getAttribute("es").toInt());
            ai.np = NumberingPlan.valueOf(xml.getAttribute("np").toInt());
            ai.nai = NatureOfAddress.valueOf(xml.getAttribute("nai").toInt());
            ai.digits = xml.getAttribute("digits").toString();
        }
    };

    public GT0100() {
    }

    public GT0100(int translationType, NumberingPlan numberingPlan, NatureOfAddress natureOfAddress, String digits) {
        this.tt = translationType;
        this.np = numberingPlan;
        this.nai = natureOfAddress;
        this.digits = digits;
        this.encodingScheme = digits.length() % 2 == 0 ? EncodingScheme.BCD_EVEN : EncodingScheme.BCD_ODD;
    }

    public int getTranslationType() {
        return this.tt;
    }

    public NumberingPlan getNumberingPlan() {
        return this.np;
    }

    public NatureOfAddress getNatureOfAddress() {
        return this.nai;
    }

    public String getDigits() {
        return this.digits;
    }

    public GlobalTitleIndicator getIndicator() {
        return gti;
    }

    public boolean equals(Object other) {
        if (!(other instanceof GlobalTitle)) {
            return false;
        }
        GlobalTitle gt = (GlobalTitle)other;
        if (gt.getIndicator() != gti) {
            return false;
        }
        GT0100 gt1 = (GT0100)gt;
        return gt1.tt == this.tt && gt1.np == this.np && gt1.nai == this.nai && gt1.digits.equals(this.digits);
    }

    public int hashCode() {
        int hash = 3;
        hash += this.tt;
        hash += this.np != null ? 1 : 0;
        hash += this.nai != null ? 1 : 0;
        return hash += this.digits != null ? this.digits.hashCode() : 0;
    }

    public String toString() {
        return "{tt=" + this.tt + ", np=" + (Object)((Object)this.np) + ", na=" + (Object)((Object)this.nai) + ", digist=" + this.digits + "}";
    }
}

