/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.protocols.ss7.indicator.EncodingScheme;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.indicator.NatureOfAddress;
import org.mobicents.protocols.ss7.indicator.NumberingPlan;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;

public class GT0100
extends GlobalTitle {
    private static final GlobalTitleIndicator gti = GlobalTitleIndicator.GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_ENCODING_SCHEME_AND_NATURE_OF_ADDRESS;
    private int translationType;
    private NumberingPlan numberingPlan;
    private EncodingScheme encodingScheme;
    private NatureOfAddress natureOfAddress;
    private String digits = "";

    public GT0100() {
    }

    public GT0100(int translationType, NumberingPlan numberingPlan, NatureOfAddress natureOfAddress, String digits) {
        this.translationType = translationType;
        this.numberingPlan = numberingPlan;
        this.natureOfAddress = natureOfAddress;
        this.digits = digits;
        this.encodingScheme = digits.length() % 2 == 0 ? EncodingScheme.BCD_EVEN : EncodingScheme.BCD_ODD;
    }

    public void decode(InputStream in) throws IOException {
        int b1 = in.read() & 0xFF;
        int b2 = in.read() & 0xFF;
        int b3 = in.read() & 0xFF;
        this.translationType = b1;
        this.encodingScheme = EncodingScheme.valueOf(b2 & 0xF);
        this.numberingPlan = NumberingPlan.valueOf((b2 & 0xF0) >> 4);
        this.natureOfAddress = NatureOfAddress.valueOf(b3 & 0x7F);
        this.digits = this.encodingScheme.decodeDigits(in);
    }

    public void encode(OutputStream out) throws IOException {
        out.write((byte)this.translationType);
        byte b = (byte)(this.numberingPlan.getValue() << 4 | this.encodingScheme.getValue());
        out.write(b);
        b = (byte)(this.natureOfAddress.getValue() & 0x7F);
        out.write(b);
        this.encodingScheme.encodeDigits(this.digits, out);
    }

    public int getTranslationType() {
        return this.translationType;
    }

    public NumberingPlan getNumberingPlan() {
        return this.numberingPlan;
    }

    public NatureOfAddress getNatureOfAddress() {
        return this.natureOfAddress;
    }

    public String getDigits() {
        return this.digits;
    }

    public GlobalTitleIndicator getIndicator() {
        return gti;
    }

    public boolean equals(Object other) {
        if (!(other instanceof GlobalTitle)) {
            return false;
        }
        GlobalTitle gt = (GlobalTitle)other;
        if (gt.getIndicator() != gti) {
            return false;
        }
        GT0100 gt1 = (GT0100)gt;
        return gt1.translationType == this.translationType && gt1.numberingPlan == this.numberingPlan && gt1.natureOfAddress == this.natureOfAddress && gt1.digits.equals(this.digits);
    }

    public int hashCode() {
        int hash = 3;
        hash = 61 * hash + this.translationType;
        hash = 61 * hash + (this.numberingPlan != null ? this.numberingPlan.hashCode() : 0);
        hash = 61 * hash + (this.natureOfAddress != null ? this.natureOfAddress.hashCode() : 0);
        hash = 61 * hash + (this.digits != null ? this.digits.hashCode() : 0);
        return hash;
    }
}

