/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.indicator;

import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.indicator.RoutingIndicator;

public class AddressIndicator {
    private GlobalTitleIndicator globalTitleIndicator;
    private boolean pcPresent;
    private boolean ssnPresent;
    private RoutingIndicator routingIndicator;

    public AddressIndicator(boolean pcPresent, boolean ssnPresent, RoutingIndicator rti, GlobalTitleIndicator gti) {
        this.pcPresent = pcPresent;
        this.ssnPresent = ssnPresent;
        this.routingIndicator = rti;
        this.globalTitleIndicator = gti;
    }

    public AddressIndicator(byte v) {
        this.pcPresent = (v & 1) == 1;
        this.ssnPresent = (v & 2) == 2;
        this.globalTitleIndicator = GlobalTitleIndicator.valueOf(v >> 2 & 0xF);
        this.routingIndicator = (v >> 6 & 1) == 1 ? RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN : RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE;
    }

    public GlobalTitleIndicator getGlobalTitleIndicator() {
        return this.globalTitleIndicator;
    }

    public boolean pcPresent() {
        return this.pcPresent;
    }

    public boolean ssnPresent() {
        return this.ssnPresent;
    }

    public RoutingIndicator getRoutingIndicator() {
        return this.routingIndicator;
    }

    public byte getValue() {
        int b = 0;
        if (this.pcPresent) {
            b |= 1;
        }
        if (this.ssnPresent) {
            b |= 2;
        }
        b |= this.globalTitleIndicator.getValue() << 2;
        if (this.routingIndicator == RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN) {
            b |= 0x40;
        }
        return (byte)b;
    }
}

