/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.protocols.ss7.indicator.EncodingScheme;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.indicator.NumberingPlan;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;

public class GT0011
extends GlobalTitle {
    private static final GlobalTitleIndicator gti = GlobalTitleIndicator.GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_AND_ENCODING_SCHEME;
    private int tt;
    private NumberingPlan np;
    private EncodingScheme es;
    private String digits;

    public GT0011() {
        this.digits = "";
    }

    public GT0011(int tt, NumberingPlan np, String digits) {
        this.tt = tt;
        this.np = np;
        this.digits = digits;
        this.es = digits.length() % 2 == 0 ? EncodingScheme.BCD_EVEN : EncodingScheme.BCD_ODD;
    }

    public void decode(InputStream in) throws IOException {
        int b;
        this.tt = b = in.read() & 0xFF;
        b = in.read() & 0xFF;
        this.es = EncodingScheme.valueOf(b & 0xF);
        this.np = NumberingPlan.valueOf((b & 0xF0) >> 4);
        this.digits = this.es.decodeDigits(in);
    }

    public void encode(OutputStream out) throws IOException {
        out.write(this.tt);
        out.write(this.np.getValue() << 4 | this.es.getValue());
        this.es.encodeDigits(this.digits, out);
    }

    public int getTranslationType() {
        return this.tt;
    }

    public NumberingPlan getNp() {
        return this.np;
    }

    public String getDigits() {
        return this.digits;
    }

    public GlobalTitleIndicator getIndicator() {
        return gti;
    }

    public boolean equals(Object other) {
        if (!(other instanceof GlobalTitle)) {
            return false;
        }
        GlobalTitle gt = (GlobalTitle)other;
        if (gt.getIndicator() != gti) {
            return false;
        }
        GT0011 gt1 = (GT0011)gt;
        return gt1.tt == this.tt && gt1.np == this.np && gt1.digits.equals(this.digits);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + this.tt;
        hash = 41 * hash + (this.np != null ? this.np.hashCode() : 0);
        hash = 41 * hash + (this.digits != null ? this.digits.hashCode() : 0);
        return hash;
    }
}

